/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.beans.JMBean;

public class MutableInteger
extends JMBean
implements Comparable<MutableInteger>,
Cloneable {
    private int value;

    public MutableInteger() {
        this.setValue(0);
    }

    public MutableInteger(int value) {
        this.setValue(value);
    }

    public MutableInteger(String value) {
        this.setValue(Integer.parseInt(value));
    }

    public MutableInteger(Integer value) {
        this.setValue(value);
    }

    public MutableInteger(MutableInteger value) {
        this.setValue(value.getValue());
    }

    public Object clone() {
        return new MutableInteger(this);
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public void increment() {
        this.increment(1);
    }

    public void decrement() {
        this.increment(-1);
    }

    public void add(int amount) {
        this.increment(amount);
    }

    public void increment(int amount) {
        this.value += amount;
    }

    public void subtract(int amount) {
        this.decrement(amount);
    }

    public void decrement(int amount) {
        if (amount < 0) {
            amount = Math.abs(amount);
        }
        this.increment(-amount);
    }

    @Override
    public int compareTo(MutableInteger that) {
        if (this.equals(that)) {
            return 0;
        }
        return this.value - that.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof MutableInteger) {
            MutableInteger that = (MutableInteger)o;
            return this.value == that.value;
        }
        return false;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }
}

