/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.lang;

import com.jmorgan.beans.JMBean;

public class MutableLong
extends JMBean
implements Comparable<MutableLong>,
Cloneable {
    private long value;

    public MutableLong() {
        this.setValue(0L);
    }

    public MutableLong(long value) {
        this.setValue(value);
    }

    public MutableLong(String value) {
        this.setValue(Integer.parseInt(value));
    }

    public MutableLong(Long value) {
        this.setValue(value.intValue());
    }

    public MutableLong(MutableLong value) {
        this.setValue(value.getValue());
    }

    public Object clone() {
        return new MutableLong(this);
    }

    public void setValue(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public void increment() {
        this.increment(1L);
    }

    public void decrement() {
        this.increment(-1L);
    }

    public void add(long amount) {
        this.increment(amount);
    }

    public void increment(long amount) {
        this.value += amount;
    }

    public void subtract(long amount) {
        this.decrement(amount);
    }

    public void decrement(long amount) {
        if (amount < 0L) {
            amount = Math.abs(amount);
        }
        this.increment(-amount);
    }

    @Override
    public int compareTo(MutableLong that) {
        if (this.equals(that)) {
            return 0;
        }
        return (int)(this.value - that.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof MutableLong) {
            MutableLong that = (MutableLong)o;
            return this.value == that.value;
        }
        return false;
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }
}

