/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.print;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public abstract class AbstractColumnPrinter
implements Printable {
    protected int columnSpacing = 10;
    protected String[] columnHeaders;
    protected int[] columnX;

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        System.out.println("DEOPrinter.print(graphics, pageFormat, pageIndex=" + pageIndex + ")  PageFormatInfo:");
        System.out.println("ImageableX: " + pageFormat.getImageableX());
        System.out.println("ImageableY: " + pageFormat.getImageableY());
        System.out.println("Width: " + pageFormat.getWidth());
        System.out.println("Height: " + pageFormat.getHeight());
        System.out.println("ImageableWidth: " + pageFormat.getImageableWidth());
        System.out.println("ImageableHeight: " + pageFormat.getImageableHeight());
        System.out.println("Orientation: " + pageFormat.getOrientation());
        System.out.println("\nPaper Info:");
        Paper paper = pageFormat.getPaper();
        System.out.println("ImageableX: " + paper.getImageableX());
        System.out.println("ImageableY: " + paper.getImageableY());
        System.out.println("Width: " + paper.getWidth());
        System.out.println("Height: " + paper.getHeight());
        System.out.println("ImageableWidth: " + paper.getImageableWidth());
        System.out.println("ImageableHeight: " + paper.getImageableHeight());
        this.columnHeaders = this.getColumnHeaders();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.columnX == null) {
            this.columnX = this.getColumnX(fontMetrics, pageFormat);
        }
        return 1;
    }

    public void setColumnHeaders(String[] columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    public int getColumnSpacing() {
        return this.columnSpacing;
    }

    public void setColumnSpacing(int columnSpacing) {
        this.columnSpacing = columnSpacing;
    }

    protected abstract String[] getColumnHeaders();

    protected abstract int[] getColumnX(FontMetrics var1, PageFormat var2);
}

