/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.PictureControl;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.WindowCloser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JEditorPane;
import javax.swing.JFrame;

public class AboutDialog
extends JMDialog {
    public AboutDialog(JFrame frame) {
        this(frame, "About");
    }

    public AboutDialog(JFrame frame, String title) {
        this(frame, title, true);
    }

    public AboutDialog(JFrame frame, String title, boolean modality) {
        super(frame, title, modality);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        GUIApplication application = GUIApplication.getGUIApplication();
        JMFrame frame = (JMFrame)GUIServices.getFrame(this);
        JMPanel panel = new JMPanel(new BorderLayout(20, 20));
        PictureControl picture = new PictureControl();
        picture.setImage(frame.getAboutDialogIcon());
        picture.setPreferredSize(100, 100);
        panel.add((Component)picture, "West");
        JEditorPane editorPane = new JEditorPane("text/html", application.getLegalLicense());
        editorPane.setEditable(false);
        editorPane.setPreferredSize(new Dimension(600, 600));
        JMScrollPane sp = new JMScrollPane(editorPane);
        panel.add((Component)sp, "Center");
        JMPanel buttonPanel = new JMPanel();
        JMButton closeButton = new JMButton("Close");
        new ActionEventInvoker(closeButton, this, "closeDialog");
        buttonPanel.add(closeButton);
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)panel, "Center");
        this.contentPane.add((Component)buttonPanel, "South");
        this.pack();
        GUIServices.centerOnWindow((Window)this.getParent(), this);
        this.setResizable(false);
    }

    public void appendProperty(StringBuilder sb, String propertyValue) {
        sb.append("<p>");
        sb.append(propertyValue);
        sb.append("</p>");
    }

    public void appendProperty(StringBuilder sb, String label, String propertyValue) {
        this.appendProperty(sb, String.format("%s: %s", label, propertyValue));
    }

    @Reflected
    private void closeDialog() {
        WindowCloser.closeWindow(this, 0, false);
    }
}

