/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.lang.GUIApplication;
import com.jmorgan.util.logging.LMG;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.Timer;

public class ApplicationSessionManager
implements AWTEventListener,
ActionListener {
    public static final int DEFAULT_SESSION_TIMEOUT = 1800000;
    private GUIApplication application;
    private Logger applicationLogger;
    private int sessionTimeout;
    private Timer sessionTimer;

    public ApplicationSessionManager(GUIApplication application) {
        this(application, 1800000);
    }

    public ApplicationSessionManager(GUIApplication application, int sessionTimeout) {
        this.setApplication(application);
        this.setSessionTimeout(sessionTimeout);
        this.sessionTimer = new Timer(this.sessionTimeout, this);
        this.sessionTimer.setRepeats(false);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    public GUIApplication getApplication() {
        return this.application;
    }

    private void setApplication(GUIApplication application) {
        this.application = application;
        this.applicationLogger = this.application.getApplicationLogger();
        this.applicationLogger.info(() -> LMG.log("(GUIApplication application=%s): Application Set", () -> application.getClass().getName()));
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        this.applicationLogger.info(() -> LMG.log("(sessionTimeout=%d): Session Timeout Set.", () -> sessionTimeout));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.applicationLogger.info("(ActionEvent e): Session Expired.  Exiting application.");
        System.exit(-100);
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.sessionTimer.restart();
        this.applicationLogger.finer("(AWTEvent event): Session Extended.");
    }
}

