/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.ListEditorPopup;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.ListCellEditor;
import com.jmorgan.util.Comparison;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.border.EmptyBorder;

public class JMList<ElementType>
extends JList<ElementType> {
    public static final int SINGLE_SELECTION = 0;
    public static final int SINGLE_INTERVAL_SELECTION = 1;
    public static final int MULTIPLE_INTERVAL_SELECTION = 2;
    private ListCellEditor listCellEditor;
    private ListEditorPopup editorPopup;

    public JMList() {
        this.standardInit();
    }

    public JMList(ArrayList<ElementType> items) {
        this.standardInit();
        this.setListData(items);
    }

    public JMList(ElementType[] items) {
        super(items);
        this.standardInit();
    }

    public JMList(Vector<ElementType> items) {
        super(items);
        this.standardInit();
    }

    public JMList(ListModel<ElementType> model) {
        super(model);
        this.standardInit();
    }

    void standardInit() {
        this.setCellRenderer(new JMListCellRenderer());
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
    }

    public ListCellEditor getListCellEditor() {
        return this.listCellEditor;
    }

    public void setCellEditor(ListCellEditor listCellEditor) {
        this.listCellEditor = listCellEditor;
        if (listCellEditor != null && this.editorPopup == null) {
            this.editorPopup = new ListEditorPopup(this);
        }
    }

    public void selectAll() {
        if (this.getSelectionMode() != 0) {
            this.getSelectionModel().setSelectionInterval(0, this.getModel().getSize() - 1);
        }
    }

    public void selectNone() {
        this.getSelectionModel().clearSelection();
    }

    public ElementType getSelectedItem() {
        return (ElementType)this.getSelectedValue();
    }

    public ElementType getItemAt(int index) {
        return (ElementType)this.getModel().getElementAt(index);
    }

    public int getIndexOf(ElementType element) {
        if (element == null) {
            return -1;
        }
        int itemCount = this.getItemCount();
        int i = 0;
        while (i < itemCount) {
            ElementType existingElement = this.getItemAt(i);
            if (existingElement != null && existingElement.equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getItemCount() {
        return this.getModel().getSize();
    }

    public void repaintSelectedCell() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex == -1) {
            return;
        }
        Rectangle cellRect = this.getCellBounds(selectedIndex, selectedIndex);
        this.repaint(cellRect);
    }

    public void repaintCellOf(ElementType element) {
        int elementIndex = this.getIndexOf(element);
        if (elementIndex == -1) {
            return;
        }
        Rectangle cellRect = this.getCellBounds(elementIndex, elementIndex);
        this.repaint(cellRect);
    }

    public boolean isIndexVisible(int index) {
        if (!this.isIndexValid(index)) {
            return false;
        }
        int firstVisible = this.getFirstVisibleIndex();
        int lastVisible = this.getLastVisibleIndex();
        return Comparison.isBetween(index, firstVisible, lastVisible);
    }

    public boolean isIndexValid(int index) {
        return index >= 0 && index < this.getModel().getSize();
    }

    public void scrollTo(int index) {
        this.setSelectedIndex(index);
        this.ensureIndexIsVisible(index);
        this.repaint();
    }

    public void scrollTo(Object value) {
        this.setSelectedValue(value, true);
    }

    @Override
    public void setListData(ArrayList<ElementType> items) {
        this.setListData((ElementType[])items.toArray());
    }

    @Override
    public void setListData(Vector items) {
        super.setListData(items);
        if (items.size() > 0) {
            this.setSelectedIndex(0);
        }
    }

    @Override
    public void setListData(ElementType[] items) {
        super.setListData(items);
        if (items.length > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void setX(int x) {
        this.setLocation(x, this.getY());
    }

    public void setY(int y) {
        this.setLocation(this.getX(), y);
    }

    public void setPreferredSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void ensureElementIsVisible(ElementType element) {
        if (element == null) {
            return;
        }
        ListModel listModel = this.getModel();
        int listModelSize = listModel.getSize();
        int i = 0;
        while (i < listModelSize) {
            Object elementAtI = listModel.getElementAt(i);
            if (elementAtI.equals(element)) {
                this.ensureIndexIsVisible(i);
                return;
            }
            ++i;
        }
    }
}

