/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.swing.DefaultSearchDialogPane;
import com.jmorgan.swing.ExitButton;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.SearchDialogPane;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.search.Searchable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class JMSearchDialog
extends JMDialog {
    private Searchable client;
    private SearchDialogPane interfaceComponent;
    private JMButton findButton;
    private ExitButton closeButton;
    private static Object searchParameters = null;

    public static Object getLastSearchParameters() {
        return searchParameters;
    }

    public JMSearchDialog(JFrame owner, Searchable client) {
        super(owner, "Find", false);
        this.client = client;
    }

    public JMSearchDialog(JDialog owner, Searchable client) {
        super(owner, "Find", false);
        this.client = client;
    }

    @Override
    public final void buildGUI(Object[] arguments) {
        this.findButton = new JMButton("Find &Next");
        final JMSearchDialog thisWindow = this;
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object parms = JMSearchDialog.this.interfaceComponent.getSearchParameters();
                if (!JMSearchDialog.this.client.search(parms)) {
                    WindowCloser.closeWindow(thisWindow, 0, false);
                }
            }
        });
        this.closeButton = new ExitButton("&Close");
        this.interfaceComponent = this.getInterfaceComponent();
        JMPanel buttonPanel = new JMPanel(new GridLayout(2, 1));
        buttonPanel.add(this.findButton);
        buttonPanel.add(this.closeButton);
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add((Component)((Object)this.interfaceComponent), "Center");
        this.contentPane.add((Component)buttonPanel, "East");
        int w = ((Component)((Object)this.interfaceComponent)).getPreferredSize().width;
        int h = ((Component)((Object)this.interfaceComponent)).getPreferredSize().height;
        this.setSize(w += ((BorderLayout)this.contentPane.getLayout()).getHgap() + buttonPanel.getPreferredSize().width, h += buttonPanel.getPreferredSize().height);
        this.setResizable(false);
        GUIServices.centerWindow(this);
    }

    public void setSearchParameters(Object parms) {
        searchParameters = parms;
    }

    protected SearchDialogPane getInterfaceComponent() {
        return new DefaultSearchDialogPane();
    }
}

