/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.awt.ShapePainter;
import com.jmorgan.swing.decorator.Decorator;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.util.HoverBorderController;
import com.jmorgan.swing.util.HoverColorController;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class JMToggleButton
extends JToggleButton {
    private String textWhenOn;
    private String textWhenOff;
    private Icon iconWhenOn;
    private Icon iconWhenOff;
    private int toolTipXOffset;
    private int toolTipYOffset;
    private Insets insets;
    private Decorator decorator;
    private Paint backgroundPaint;
    private Paint borderPaint;
    private String iconName;
    private String disabledIconName;
    private String disabledSelectedIconName;
    private String pressedIconName;
    private String rolloverIconName;
    private String rollOverSelectedIconName;
    private String selectedIconName;
    private ShapeCreator shapeCreator;
    private ShapePainter shapePainterDelegate;

    public JMToggleButton() {
        this(null, null, false);
    }

    public JMToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JMToggleButton(String text) {
        this(text, null, false);
    }

    public JMToggleButton(Action action) {
        super(action);
        this.standardInit();
    }

    public JMToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JMToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public JMToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JMToggleButton(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        if (selected) {
            this.setTextWhenOn(text);
            this.setIconWhenOn(icon);
        } else {
            this.setTextWhenOff(text);
            this.setIconWhenOff(icon);
        }
        this.standardInit();
    }

    private void standardInit() {
        Paint borderPaint;
        Paint paint;
        ShapeCreator shapeCreator;
        HoverBorderController buttonBorderRollover;
        HoverColorController buttonRollover;
        this.insets = new Insets(2, 8, 2, 8);
        this.toolTipYOffset = -1;
        this.toolTipXOffset = 20;
        this.setCursor(new Cursor(12));
        String label = this.getText();
        if (label != null) {
            this.setToolTipText(label);
        }
        if ((buttonRollover = (HoverColorController)UIManager.get("ToggleButton.backgroundHover")) != null) {
            buttonRollover.addComponent(this);
        }
        if ((buttonBorderRollover = (HoverBorderController)UIManager.get("ToggleButton.borderHover")) != null) {
            buttonBorderRollover.addComponent(this);
        }
        if ((shapeCreator = (ShapeCreator)UIManager.get("ToggleButton.shapeCreator")) != null) {
            this.setShapeCreator(shapeCreator);
        }
        if ((paint = (Paint)UIManager.get("ToggleButton.backgroundPaint")) != null) {
            this.setBackgroundPaint(paint);
        }
        if ((borderPaint = (Paint)UIManager.get("ToggleButton.borderPaint")) != null) {
            this.setBorderPaint(borderPaint);
        }
        new ActionEventInvoker(this, this, "handleToggleAction");
    }

    @Reflected
    private void handleToggleAction() {
        boolean isSelected = this.isSelected();
        String text = null;
        Icon icon = null;
        if (isSelected) {
            text = this.getTextWhenOn();
            icon = this.getIconWhenOn();
        } else {
            text = this.getTextWhenOff();
            icon = this.getIconWhenOff();
        }
        if (text == null) {
            text = this.getText();
        }
        if (icon == null) {
            icon = this.getIcon();
        }
        if (text != null) {
            this.setText(text);
        }
        if (icon != null) {
            this.setIcon(icon);
        }
    }

    public String getTextWhenOn() {
        return this.textWhenOn;
    }

    public void setTextWhenOn(String textWhenOn) {
        this.textWhenOn = textWhenOn;
    }

    public String getTextWhenOff() {
        return this.textWhenOff;
    }

    public void setTextWhenOff(String textWhenOff) {
        this.textWhenOff = textWhenOff;
    }

    public Icon getIconWhenOn() {
        return this.iconWhenOn;
    }

    public void setIconWhenOn(Icon iconWhenOn) {
        this.iconWhenOn = iconWhenOn;
    }

    public Icon getIconWhenOff() {
        return this.iconWhenOff;
    }

    public void setIconWhenOff(Icon iconWhenOff) {
        this.iconWhenOff = iconWhenOff;
    }

    public int getToolTipXOffset() {
        return this.toolTipXOffset;
    }

    public void setToolTipXOffset(int toolTipXOffset) {
        this.toolTipXOffset = toolTipXOffset;
    }

    public int getToolTipYOffset() {
        return this.toolTipYOffset;
    }

    public void setToolTipYOffset(int toolTipYOffset) {
        this.toolTipYOffset = toolTipYOffset;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public void setBorderPaint(Paint borderPaint) {
        this.borderPaint = borderPaint;
    }

    public String getIconName() {
        return this.iconName;
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public String getDisabledIconName() {
        return this.disabledIconName;
    }

    public void setDisabledIconName(String disabledIconName) {
        this.disabledIconName = disabledIconName;
    }

    public String getDisabledSelectedIconName() {
        return this.disabledSelectedIconName;
    }

    public void setDisabledSelectedIconName(String disabledSelectedIconName) {
        this.disabledSelectedIconName = disabledSelectedIconName;
    }

    public String getPressedIconName() {
        return this.pressedIconName;
    }

    public void setPressedIconName(String pressedIconName) {
        this.pressedIconName = pressedIconName;
    }

    public String getRolloverIconName() {
        return this.rolloverIconName;
    }

    public void setRolloverIconName(String rolloverIconName) {
        this.rolloverIconName = rolloverIconName;
    }

    public String getRollOverSelectedIconName() {
        return this.rollOverSelectedIconName;
    }

    public void setRollOverSelectedIconName(String rollOverSelectedIconName) {
        this.rollOverSelectedIconName = rollOverSelectedIconName;
    }

    public String getSelectedIconName() {
        return this.selectedIconName;
    }

    public void setSelectedIconName(String selectedIconName) {
        this.selectedIconName = selectedIconName;
    }

    public ShapeCreator getShapeCreator() {
        return this.shapeCreator;
    }

    public void setShapeCreator(ShapeCreator shapeCreator) {
        this.shapeCreator = shapeCreator;
    }

    public ShapePainter getShapePainterDelegate() {
        return this.shapePainterDelegate;
    }

    public void setShapePainterDelegate(ShapePainter shapePainterDelegate) {
        this.shapePainterDelegate = shapePainterDelegate;
    }
}

