/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.event.InternalFrameEventInvoker;
import com.jmorgan.swing.event.WindowEventInvoker;
import com.jmorgan.swing.list.ListCellEditor;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import javax.swing.JInternalFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ListEditorPopup
implements ListSelectionListener,
ComponentListener,
AWTEventListener,
AdjustmentListener {
    private JMList<?> list;
    private Component editorComponent;
    private JWindow popupWindow;
    private JScrollPane scrollPane;
    private boolean moveResizeAction = false;
    private long lastComponentMoveResize;
    private AsynchMethodInvoker<Void> moveResizeController;
    private boolean positionChanging;

    public ListEditorPopup(JMList<?> list) {
        this.list = list;
        this.list.addListSelectionListener(this);
        new AsynchMethodInvoker((Object)this, "setListeners", 200);
    }

    @Reflected
    void setListeners() {
        Window window = ComponentService.getParentWindow(this.list);
        if (window == null) {
            new AsynchMethodInvoker((Object)this, "setListeners", 200);
            return;
        }
        new WindowEventInvoker((Object)window, 44, this, "hidePopup");
        Container c = this.list.getParent();
        while (c != null) {
            if (c instanceof JInternalFrame) {
                JInternalFrame iFrame = (JInternalFrame)c;
                new InternalFrameEventInvoker((Object)iFrame, 44, this, "hidePopup");
            }
            if (c instanceof JScrollPane) {
                this.scrollPane = (JScrollPane)c;
                this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
                this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
            }
            c.addComponentListener(this);
            c = c.getParent();
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.hidePopup();
        JMList list = (JMList)e.getSource();
        if (list.getModel().getSize() == 0) {
            return;
        }
        if (e.getFirstIndex() != -1 && this.list.isShowing()) {
            this.showPopup();
        }
    }

    @Reflected
    public synchronized void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            if (this.editorComponent != null) {
                this.popupWindow.remove(this.editorComponent);
            }
            this.popupWindow.dispose();
            this.popupWindow = null;
            if (this.editorComponent != null) {
                this.editorComponent = null;
            }
        }
    }

    private synchronized void showPopup() {
        int index = this.list.getSelectedIndex();
        int modelSize = this.list.getModel().getSize();
        if (modelSize == 0 || index < 0 || index >= modelSize) {
            if (index >= modelSize) {
                System.err.printf("ListEditorPopup.showPopup(): Selected Index out of range. Selected Index = %d, Model Size = %d\n", index, modelSize);
            }
            return;
        }
        Object selectedValue = this.list.getSelectedValue();
        ListCellEditor editor = this.list.getListCellEditor();
        this.editorComponent = editor.getListCellEditorComponent(this.list, selectedValue, index);
        if (this.editorComponent != null) {
            Window parentWindow = GUIServices.getParentWindow(this.list);
            if (this.popupWindow != null) {
                this.hidePopup();
            }
            this.popupWindow = new JWindow(parentWindow);
            this.popupWindow.setLayout(null);
            this.positionPopup();
            this.popupWindow.add(this.editorComponent);
            this.popupWindow.setVisible(true);
            this.popupWindow.requestFocus();
        }
    }

    private synchronized void positionPopup() {
        if (this.popupWindow == null || this.list == null || this.positionChanging) {
            return;
        }
        this.positionChanging = true;
        try {
            int index = this.list.getSelectedIndex();
            int modelSize = this.list.getModel().getSize();
            if (modelSize == 0 || index < 0 || index >= modelSize) {
                return;
            }
            boolean indexVisible = this.list.isIndexVisible(index);
            if (!indexVisible) {
                this.popupWindow.setVisible(false);
                return;
            }
            Rectangle listBounds = this.list.getBounds();
            Point listLocation = new Point(listBounds.x, listBounds.y);
            Rectangle cellBounds = this.list.getCellBounds(index, index);
            Point cellLocation = new Point(cellBounds.x, cellBounds.y);
            int cellY = cellLocation.y;
            int listY = listLocation.y;
            int cellYLocation = cellY + listY;
            if (cellYLocation < 0) {
                this.popupWindow.setVisible(false);
                return;
            }
            this.popupWindow.setVisible(true);
            SwingUtilities.convertPointToScreen(listLocation, this.list);
            Rectangle scrollBounds = new Rectangle(cellBounds);
            Point scrollLocation = new Point(scrollBounds.x, scrollBounds.y);
            SwingUtilities.convertPointToScreen(cellLocation, this.list);
            SwingUtilities.convertPointToScreen(scrollLocation, this.list);
            if (this.scrollPane != null) {
                scrollBounds = this.scrollPane.getBounds();
                scrollLocation = new Point(scrollBounds.x, scrollBounds.y);
                SwingUtilities.convertPointToScreen(scrollLocation, this.scrollPane.getParent());
                cellYLocation = cellY + cellBounds.height + listY;
                if (cellYLocation > scrollBounds.height) {
                    this.popupWindow.setVisible(false);
                    return;
                }
                JScrollBar hsb = this.scrollPane.getHorizontalScrollBar();
                if (hsb.isShowing()) {
                    cellBounds.width = this.scrollPane.getWidth() - 2;
                    JScrollBar vsb = this.scrollPane.getVerticalScrollBar();
                    if (vsb.isShowing()) {
                        cellBounds.width -= vsb.getWidth() - 2;
                    }
                }
            }
            Dimension listSize = this.list.getSize();
            this.editorComponent.setBounds(listBounds.x, 0, listSize.width, cellBounds.height);
            this.popupWindow.setBounds(scrollLocation.x, cellLocation.y, cellBounds.width - 2, cellBounds.height);
        }
        finally {
            this.positionChanging = false;
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.hidePopup();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.moveResize();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.moveResize();
    }

    private void moveResize() {
        if (this.moveResizeAction) {
            return;
        }
        this.moveResizeAction = true;
        this.hidePopup();
        if (this.moveResizeController != null) {
            this.moveResizeController.cancel();
            this.moveResizeController = null;
        }
        this.moveResizeController = new AsynchMethodInvoker((Object)this, "safeToShowAfterMoveResize", 100);
        this.moveResizeAction = false;
    }

    @Reflected
    void safeToShowAfterMoveResize() {
        long now;
        long elapsed;
        if (this.lastComponentMoveResize == 0L) {
            this.lastComponentMoveResize = System.currentTimeMillis();
        }
        if ((elapsed = (now = System.currentTimeMillis()) - this.lastComponentMoveResize) > 500L) {
            this.lastComponentMoveResize = 0L;
            this.moveResizeController = null;
            this.showPopup();
        }
        this.lastComponentMoveResize = now;
    }

    @Override
    public void componentShown(ComponentEvent e) {
        boolean allParentsShowing = true;
        Container parent = this.list.getParent();
        while (parent != null && allParentsShowing) {
            allParentsShowing = parent.isShowing();
            parent = parent.getParent();
        }
        if (allParentsShowing && this.list != null && this.list.getSelectedIndex() >= 0) {
            this.showPopup();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.positionPopup();
    }

    @Override
    public synchronized void eventDispatched(AWTEvent event) {
        if (this.popupWindow == null || !this.doesPopupHaveFocus()) {
            return;
        }
        KeyEvent ke = (KeyEvent)event;
        int keyCode = ke.getKeyCode();
        int keyEventID = ke.getID();
        if ((keyCode == 40 || keyCode == 38) && keyEventID == 402) {
            int currentIndex = this.list.getSelectedIndex();
            int lastIndex = this.list.getModel().getSize() - 1;
            int nextIndex = 0;
            if (currentIndex != -1) {
                if (keyCode == 40) {
                    nextIndex = currentIndex + 1;
                    if (nextIndex >= lastIndex) {
                        nextIndex = 0;
                    }
                } else {
                    nextIndex = currentIndex - 1;
                    if (nextIndex == -1) {
                        nextIndex = lastIndex;
                    }
                }
            }
            this.list.scrollTo(nextIndex);
        }
    }

    private boolean doesPopupHaveFocus() {
        Container container;
        Component focusComponent;
        if (this.popupWindow == null || this.editorComponent == null) {
            return false;
        }
        if (this.popupWindow.hasFocus()) {
            return true;
        }
        if (this.editorComponent.hasFocus()) {
            return true;
        }
        return this.editorComponent instanceof Container && (focusComponent = GUIServices.getFocusedComponent(container = (Container)this.editorComponent)) != null;
    }
}

