/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.image.ImageUtilities;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.util.InsetsFactory;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class PictureControl
extends JMLabel {
    private Image image;
    private Point imageOffset = new Point(0, 0);
    private boolean scaleToControl = true;
    private boolean distortScaling;
    private boolean centerPicture = true;
    private String imageName;
    private Dimension lastEraserSize;
    private Image eraser;

    public PictureControl() {
    }

    public PictureControl(Image picture) {
        this();
        this.setImage(picture);
    }

    public PictureControl(Image picture, Point offset) {
        this();
        this.setImageOffset(offset);
        this.centerPicture = false;
        this.setImage(picture);
    }

    public PictureControl(Image picture, int x, int y) {
        this(picture, new Point(x, y));
    }

    @Override
    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public Image getImage() {
        return this.image;
    }

    public synchronized void setImage(Image picture) {
        if (picture == null) {
            return;
        }
        this.image = picture;
        Dimension thisSize = this.getSize();
        if (!this.scaleToControl || thisSize.width == 0 || thisSize.height == 0) {
            int w = (int)((double)picture.getWidth(this) + this.imageOffset.getX() * 2.0);
            int h = (int)((double)picture.getHeight(this) + this.imageOffset.getY() * 2.0);
            this.setSize(w, h);
            thisSize.width = w;
            thisSize.height = h;
        }
        if (thisSize.width <= 0 || thisSize.height <= 0) {
            return;
        }
        this.paint(this.getGraphics());
    }

    public synchronized void erase() {
        Dimension thisSize = this.getSize();
        if (this.lastEraserSize == null || !thisSize.equals(this.lastEraserSize)) {
            this.eraser = null;
        }
        this.lastEraserSize = thisSize;
        if (this.eraser == null) {
            System.out.println("PictureControl.erase():  Creating new eraser");
            this.eraser = new BufferedImage(thisSize.width, thisSize.height, 1);
            Graphics2D g2d = (Graphics2D)this.eraser.getGraphics();
            g2d.setPaint(UIManager.getColor("Label.background"));
            g2d.fillRect(0, 0, thisSize.width, thisSize.height);
            g2d.dispose();
        }
        this.setImage(this.eraser);
    }

    public Point getImageOffset() {
        return this.imageOffset;
    }

    public synchronized void setImageOffset(Point offset) {
        this.imageOffset = offset;
        this.centerPicture = false;
    }

    public synchronized void setImageOffset(int x, int y) {
        this.setImageOffset(new Point(x, y));
    }

    public boolean isCenterPicture() {
        return this.centerPicture;
    }

    public void setCenterPicture(boolean centerPicture) {
        this.centerPicture = centerPicture;
    }

    public boolean isScaleToControl() {
        return this.scaleToControl;
    }

    public void setScaleToControl(boolean scaleToControl) {
        this.scaleToControl = scaleToControl;
    }

    public boolean isDistortScaling() {
        return this.distortScaling;
    }

    public void setDistortScaling(boolean distortScaling) {
        this.distortScaling = distortScaling;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        super.paint(g);
        Border border = this.getBorder();
        Insets borderInsets = border == null ? InsetsFactory.createFixedInsets(0) : border.getBorderInsets(this);
        Graphics graphics = g;
        synchronized (graphics) {
            if (this.image == null) {
                return;
            }
            int x = 0;
            int y = 0;
            Dimension thisSize = new Dimension(this.getSize());
            thisSize.width -= borderInsets.left + borderInsets.right;
            thisSize.height -= borderInsets.top + borderInsets.bottom;
            Image imageToDraw = this.image;
            if (this.scaleToControl) {
                Dimension scaledSize = this.getScaledSize();
                imageToDraw = ImageUtilities.getScaledImage(this.image, scaledSize.width, scaledSize.height);
            }
            Dimension imageSize = new Dimension(imageToDraw.getWidth(this), imageToDraw.getHeight(this));
            if (this.centerPicture) {
                x = thisSize.width / 2 - imageSize.width / 2;
                y = thisSize.height / 2 - imageSize.height / 2;
            } else {
                x = (int)this.imageOffset.getX();
                y = (int)this.imageOffset.getY();
            }
            g.drawImage(imageToDraw, x += borderInsets.left, y += borderInsets.top, imageSize.width, imageSize.height, this);
        }
    }

    private Dimension getScaledSize() {
        Border border;
        Dimension newSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
        Dimension thisSize = this.getSize();
        if (thisSize.width <= 0 || thisSize.height <= 0) {
            thisSize.setSize(50, 50);
        }
        Insets borderInsets = (border = this.getBorder()) == null ? InsetsFactory.createFixedInsets(0) : border.getBorderInsets(this);
        thisSize.width -= borderInsets.left + borderInsets.right;
        thisSize.height -= borderInsets.top + borderInsets.bottom;
        if (this.distortScaling) {
            newSize.setSize(thisSize);
        } else {
            if (newSize.width > thisSize.width && newSize.height > thisSize.height || newSize.width < thisSize.width && newSize.height < thisSize.height) {
                int maxDimension = Math.max(newSize.width, newSize.height);
                if (maxDimension == newSize.width) {
                    double scale = (double)thisSize.width / (double)newSize.width;
                    newSize.width = thisSize.width;
                    newSize.height = (int)((double)newSize.height * scale);
                } else {
                    double scale = (double)thisSize.height / (double)newSize.height;
                    newSize.height = thisSize.height;
                    newSize.width = (int)((double)newSize.width * scale);
                }
            }
            if (newSize.width > thisSize.width) {
                double scale = (double)thisSize.width / (double)newSize.width;
                newSize.width = thisSize.width;
                newSize.height = (int)((double)newSize.height * scale);
                return newSize;
            }
            if (newSize.height > thisSize.height) {
                double scale = (double)thisSize.height / (double)newSize.height;
                newSize.height = thisSize.height;
                newSize.width = (int)((double)newSize.width * scale);
            }
        }
        return newSize;
    }
}

