/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing;

import com.jmorgan.lang.GUIApplication;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.util.logging.LMG;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JRootPane;

public class ScreenKeyAndMouseClickOverlay
extends JMPanel
implements AWTEventListener {
    private static final int MAX_DISPLAY_LENGTH = 20;
    private GUIApplication application;
    private Logger applicationLogger;
    private JLabel display;

    public ScreenKeyAndMouseClickOverlay(GUIApplication application) {
        super(new BorderLayout());
        this.setSize(200, 20);
        this.display = new JLabel();
        this.add(this.display);
        this.setApplication(application);
        JMFrame frame = application.getApplicationFrame();
        JRootPane rootPane = frame.getRootPane();
        rootPane.add(this);
        this.setLocation(20, 200);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
    }

    public GUIApplication getApplication() {
        return this.application;
    }

    private void setApplication(GUIApplication application) {
        this.application = application;
        this.applicationLogger = this.application.getApplicationLogger();
        this.applicationLogger.info(() -> LMG.log("(GUIApplication application=%s): Application Set", () -> application.getClass().getName()));
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.getID() == 400) {
                char key;
                String modifierText = this.getModifierText(keyEvent);
                if (modifierText != "") {
                    this.setText(modifierText);
                }
                if (Character.isAlphabetic(key = keyEvent.getKeyChar())) {
                    this.setText(Character.toString(key));
                }
            }
        } else if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            int modifiers = mouseEvent.getModifiersEx();
            this.setText(Integer.toString(modifiers));
            if ((modifiers & 0x1F6) == 502) {
                int button;
                String modifierText = this.getModifierText(mouseEvent);
                if (modifierText != "") {
                    this.setText(modifierText);
                }
                if ((button = mouseEvent.getButton()) > 0) {
                    String buttonName = switch (button) {
                        case 1 -> "Left";
                        case 2 -> "Middle";
                        case 3 -> "Right";
                        default -> "Unk";
                    };
                    this.setText(buttonName);
                }
            }
        }
    }

    private String getModifierText(InputEvent event) {
        String modifierText = "";
        if (event.isControlDown()) {
            modifierText = "CTRL";
        } else if (event.isAltDown()) {
            modifierText = "ALT";
        } else if (event.isShiftDown()) {
            modifierText = "SHIFT";
        }
        return modifierText;
    }

    private void setText(String text) {
        String currentText = this.display.getText();
        int length = currentText.length();
        if (length > 20) {
            currentText = currentText.substring(length - 20);
        }
        this.display.setText(currentText + " " + text);
    }
}

