/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar;

import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.decorator.ArrowDecorator;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.UIManager;

class ArrowPanel
extends JMPanel {
    private JMButton monthButton;
    private JMButton yearButton;

    public ArrowPanel(int direction) {
        super(new FlowLayout(direction == 7 ? 0 : 2));
        Dimension buttonSize = new Dimension(22, 22);
        String directionName = direction == 7 ? "prior" : "next";
        String tooltipName = direction == 7 ? "Prior " : "Next";
        this.monthButton = new JMButton(new ArrowDecorator(direction, UIManager.getColor("Textfield.foreground")));
        this.monthButton.setPreferredSize(buttonSize);
        this.monthButton.setActionCommand(directionName + "month");
        this.monthButton.setToolTipText(tooltipName + " Month");
        ArrowDecorator doubleDecorator = new ArrowDecorator(direction, UIManager.getColor("Textfield.foreground"));
        doubleDecorator.setArrowCount(2);
        this.yearButton = new JMButton(doubleDecorator);
        this.yearButton.setPreferredSize(buttonSize);
        this.yearButton.setActionCommand(directionName + "year");
        this.yearButton.setToolTipText(tooltipName + " Year");
        switch (direction) {
            case 7: {
                this.add(this.yearButton);
                this.add(this.monthButton);
                break;
            }
            case 3: {
                this.add(this.monthButton);
                this.add(this.yearButton);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.monthButton.addActionListener(actionListener);
        this.yearButton.addActionListener(actionListener);
    }
}

