/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.panels;

import com.jmorgan.swing.ActiveLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.calendar.model.CalendarModel;
import com.jmorgan.swing.calendar.panels.DefaultDayContainer;
import com.jmorgan.swing.calendar.panels.EntryListCellRenderer;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;

public class FullSizeContainer
extends DefaultDayContainer
implements PropertyChangeListener,
ActionListener,
MouseListener {
    private JMPanel uiComponent;
    private DefaultListModel listModel;
    private JMList list;
    private EntryListCellRenderer renderer;
    private ActiveLabel dateText = new ActiveLabel("", 4);
    private CalendarModel dataModel;

    public FullSizeContainer() {
        this.dateText.addActionListener(this);
        this.uiComponent.add((Component)this.dateText, "North");
        styleController.addComponent(this.dateText);
        this.listModel = new DefaultListModel();
        this.list = new JMList(this.listModel);
        this.list.addMouseListener(this);
        this.renderer = new EntryListCellRenderer();
        this.list.setCellRenderer(this.renderer);
        this.uiComponent.add((Component)new JMScrollPane(this.list), "Center");
    }

    @Override
    public JComponent getUIComponent() {
        if (this.uiComponent == null) {
            this.uiComponent = new JMPanel(new BorderLayout());
        }
        return this.uiComponent;
    }

    public JMList getList() {
        return this.list;
    }

    @Override
    public void setCalendarModel(CalendarModel model) {
        this.dataModel = model;
        if (this.dataModel == null) {
            return;
        }
        this.dataModel.addPropertyChangeListener(this);
    }

    @Override
    public void setDate(Calendar date, Calendar selectedDate) {
        super.setDate(date, selectedDate);
        this.listModel.clear();
        if (date == null) {
            this.dateText.setText("");
            return;
        }
        this.dateText.setText("" + date.get(5));
        ArrayList<Object> entries = new ArrayList<Object>();
        if (DateMetaData.isHoliday(date)) {
            entries.add(DateMetaData.getHolidayName(date));
        }
        if (this.dataModel != null) {
            Date thisDate = new Date(date);
            entries.addAll(this.dataModel.getAppointments(thisDate));
            entries.addAll(this.dataModel.getEvents(thisDate));
            entries.addAll(this.dataModel.getTasks(thisDate));
        }
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            this.listModel.addElement(i.next());
        }
    }

    @Override
    public void setDisplayStyle(TextStyle textStyle) {
        this.dateText.setForeground(textStyle.getColor().getForeground());
        this.dateText.setBackground(textStyle.getColor().getBackground());
        this.dateText.setFont(textStyle.getFont());
        this.uiComponent.setBackground(textStyle.getColor().getBackground());
        this.list.setBackground(textStyle.getColor().getBackground());
        this.renderer.setForeground(textStyle.getColor().getForeground());
        this.renderer.setBackground(textStyle.getColor().getBackground());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setDate(this.getDate(), this.getSelectedDate());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.sendCalendarSelectionEvent();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.sendCalendarSelectionEvent();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

