/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.calendar.panels;

import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.calendar.CalendarSelectionListener;
import com.jmorgan.swing.calendar.DayContainer;
import com.jmorgan.swing.calendar.panels.DefaultDayContainer;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.util.DateMetaData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.border.BevelBorder;

public class MediumDayContainer
extends DefaultDayContainer
implements DayContainer {
    static final Font textFont = new Font("TimesRoman", 1, 12);
    static final BevelBorder panelBorder = new BevelBorder(0, Color.lightGray, Color.darkGray);
    private JMPanel uiComponent;
    private Color textColor;
    private Color defaultBackground;
    private Color todayColor;
    private Color dailyColor = Color.cyan;
    private Color weekendColor = Color.green;
    private Color holidayColor = Color.red;
    private String textString;
    Calendar today;

    public MediumDayContainer() {
        this(Color.blue, Color.lightGray);
    }

    public MediumDayContainer(Color back) {
        this(back, back.equals(Color.lightGray) ? Color.blue : Color.lightGray);
    }

    public MediumDayContainer(Color back, Color todaysColor) {
        this.uiComponent = new JMPanel();
        this.uiComponent.setPreferredSize(new Dimension(40, 40));
        this.today = Calendar.getInstance();
        this.defaultBackground = back;
        this.todayColor = todaysColor;
        this.uiComponent.setBackground(this.defaultBackground);
        this.uiComponent.setFont(textFont);
        this.uiComponent.setBorder(panelBorder);
    }

    @Override
    public JComponent getUIComponent() {
        return this.uiComponent;
    }

    @Override
    public void setDate(Calendar date, Calendar activeMonth) {
        if (date == null) {
            this.setText("");
            this.uiComponent.repaint(1L);
            return;
        }
        if (date.get(2) == this.today.get(2) && date.get(5) == this.today.get(5) && date.get(1) == this.today.get(1)) {
            this.uiComponent.setBackground(this.todayColor);
        } else {
            this.uiComponent.setBackground(this.defaultBackground);
        }
        this.setText("" + date.get(5), this.getDailyColor(date));
    }

    private void setText(String s, Color c) {
        this.textString = s;
        this.textColor = c;
        this.uiComponent.repaint(1L);
    }

    private void setText(String s) {
        this.textString = s;
        this.uiComponent.repaint(1L);
    }

    public void setDailyColor(Color c) {
        this.dailyColor = c;
    }

    public void setWeekendColor(Color c) {
        this.weekendColor = c;
    }

    public void setHolidayColor(Color c) {
        this.holidayColor = c;
    }

    Color getDailyColor(Calendar date) {
        int dn = date.get(7);
        if (DateMetaData.isHoliday(date)) {
            return this.holidayColor;
        }
        return dn == 1 || dn == 7 ? this.weekendColor : this.dailyColor;
    }

    @Override
    public void addCalendarSelectionListener(CalendarSelectionListener listener) {
    }

    @Override
    public void setDisplayStyle(TextStyle textStyle) {
    }
}

