/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.awt.ComboBoxShapeCreator;
import com.jmorgan.awt.ShapeCreator;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.combobox.ComboBoxController;
import com.jmorgan.swing.combobox.DefaultComboBoxButton;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.event.FocusEventInvoker;
import com.jmorgan.swing.event.MouseEventInvoker;
import com.jmorgan.swing.util.ComponentService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JButton;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ComboBox
extends JMPanel
implements HierarchyListener,
HierarchyBoundsListener {
    private JButton dropDownButton;
    private ComboBoxController controller;
    private Window popupWindow;
    private Window parentWindow;
    private JMPanel contentPane;
    private boolean dropDownBorderSet;
    private ActionEventInvoker actionEventInvoker;
    private FocusEventInvoker focusEventInvoker;
    private Dimension preferredDropDownComponentSize;

    public ComboBox() {
        super(new BorderLayout());
        this.setOpaque(false);
        this.contentPane = new JMPanel(new BorderLayout());
        this.contentPane.setOpaque(false);
        this.contentPane.setShapeCreator(null);
        this.setShapeCreator(null);
        this.addHierarchyListener(this);
        new ComponentEventInvoker(this, 1, (Object)this, "setVisible", false);
        new ComponentEventInvoker(this, 1, (Object)this, "positionPopup");
        this.setComboBoxButton(new DefaultComboBoxButton());
    }

    public ComboBox(ComboBoxController controller) {
        this();
        this.setController(controller);
    }

    public ComboBoxController getController() {
        return this.controller;
    }

    public void setController(ComboBoxController controller) {
        Component component = null;
        if (this.controller != null) {
            component = this.controller.getAttachToComponent();
            this.remove(component);
            component = this.controller.getDropDownComponent();
            this.contentPane.remove(component);
        }
        component = controller.getDropDownComponent();
        this.contentPane.add(component, "Center");
        this.controller = controller;
        controller.setComboBox(this);
        component = controller.getAttachToComponent();
        this.add(component, "Center");
        this.dropDownButton.setIcon(controller.getDropDownIcon());
        this.dropDownButton.setToolTipText(controller.getToolTip());
        this.dropDownButton.setFocusable(false);
        ComboBoxShapeCreator shapeCreator = (ComboBoxShapeCreator)UIManager.get("ComboBox.shapeCreator");
        if (shapeCreator != null) {
            if (component instanceof JMTextField) {
                JMTextField tf = (JMTextField)component;
                tf.setShapeCreator(shapeCreator.getComponentShapeCreator());
            }
            if (this.dropDownButton instanceof JMButton) {
                JMButton btn = (JMButton)this.dropDownButton;
                btn.setShapeCreator(shapeCreator.getButtonShapeCreator());
            }
        }
    }

    @Override
    public void setBorder(Border border) {
        super.setBorder(border);
        if (!this.dropDownBorderSet && this.contentPane != null) {
            this.contentPane.setBorder(border);
        }
    }

    public void setDropDownBorder(Border border) {
        this.contentPane.setBorder(border);
        this.dropDownBorderSet = true;
    }

    public Dimension getPreferredDropDownComponentSize() {
        return this.preferredDropDownComponentSize;
    }

    public void setPreferredDropDownComponentSize(int width, int height) {
        this.setPreferredDropDownComponentSize(new Dimension(width, height));
    }

    public void setPreferredDropDownComponentSize(Dimension preferredDropDownComponentSize) {
        this.preferredDropDownComponentSize = preferredDropDownComponentSize;
    }

    public void synchronizeBorders() {
        this.contentPane.setBorder(this.getBorder());
        this.dropDownBorderSet = false;
    }

    public Component getPopupComponent() {
        if (this.popupWindow == null) {
            this.createPopupWindow();
        }
        return this.popupWindow;
    }

    void showPopup() {
        if (this.popupWindow == null) {
            this.createPopupWindow();
        }
        this.positionPopup();
        this.popupWindow.setVisible(true);
        this.controller.getAttachToComponent().requestFocus();
        this.addHierarchyBoundsListener(this);
        new AsynchMethodInvoker((Object)this, "closePopupOnComponentFocus", 50);
    }

    @Reflected
    public final void closePopupOnComponentFocus() {
        Component c;
        if (!this.popupWindow.isVisible()) {
            return;
        }
        if (this.controller.getAttachToComponent().isShowing() && this.controller.getAttachToComponent().isVisible() && ((c = this.parentWindow.getFocusOwner()) == this || c == this.popupWindow || c == this.dropDownButton || c == this.controller.getAttachToComponent() || c == this.controller.getDropDownComponent() || c == null)) {
            new AsynchMethodInvoker((Object)this, "closePopupOnComponentFocus", 25);
            return;
        }
        this.hidePopup();
    }

    private void createPopupWindow() {
        if (this.popupWindow == null) {
            if (this.parentWindow == null) {
                this.parentWindow = ComponentService.getParentWindow(this);
            }
            this.popupWindow = new Window(this.parentWindow);
            this.popupWindow.setLayout(new BorderLayout());
            this.popupWindow.add((Component)this.contentPane, "Center");
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 1L) == 1L) {
            try {
                Container newParent = e.getChangedParent();
                if (!newParent.getClass().getName().equals("sun.plugin2.main.client.PluginEmbeddedFrame")) {
                    new MouseEventInvoker((Object)newParent, 16, this, "parentMouseClicked");
                }
            }
            catch (SecurityException newParent) {
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Reflected
    public void parentMouseClicked() {
        if (this.isPopupWindowVisible()) {
            this.dropDownButtonClicked();
        }
    }

    @Override
    public void ancestorMoved(HierarchyEvent e) {
        this.positionPopup();
    }

    @Override
    public void ancestorResized(HierarchyEvent e) {
        this.positionPopup();
    }

    @Reflected
    public void positionPopup() {
        Component comboComponent = this.controller.getDropDownComponent();
        Point point = this.getLocationOnScreen();
        point.y += this.getHeight();
        Dimension ddCompSize = comboComponent.getPreferredSize();
        int width = Math.max(ddCompSize.width, this.getWidth());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (point.y > screenSize.height) {
            screenSize.height = point.y + ddCompSize.height;
        }
        if (point.y + ddCompSize.height > screenSize.height) {
            point.y = this.getLocationOnScreen().y - ddCompSize.height;
        }
        if (this.preferredDropDownComponentSize != null) {
            if (this.preferredDropDownComponentSize.width > 0) {
                width = this.preferredDropDownComponentSize.width;
            }
            if (this.preferredDropDownComponentSize.height > 0) {
                ddCompSize.height = this.preferredDropDownComponentSize.height;
            }
        }
        this.popupWindow.setBounds(point.x, point.y, width, ddCompSize.height);
    }

    public void hidePopup() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
        }
        this.removeHierarchyBoundsListener(this);
    }

    public JButton getComboBoxButton() {
        return this.dropDownButton;
    }

    public void setComboBoxButton(JButton button) {
        if (this.dropDownButton != null) {
            this.actionEventInvoker.setEventProducer(null);
            this.focusEventInvoker.setEventProducer(null);
            this.remove(this.dropDownButton);
        }
        this.dropDownButton = button;
        if (this.actionEventInvoker == null) {
            this.actionEventInvoker = new ActionEventInvoker(this.dropDownButton, this, "dropDownButtonClicked");
        } else {
            this.actionEventInvoker.setEventProducer(this.dropDownButton);
        }
        if (this.focusEventInvoker == null) {
            this.focusEventInvoker = new FocusEventInvoker(this.dropDownButton, 1, (Object)this, "dropDownButtonClicked");
        } else {
            this.focusEventInvoker.setEventProducer(this.dropDownButton);
        }
        this.add((Component)this.dropDownButton, "East");
    }

    @Reflected
    public void dropDownButtonClicked() {
        if (this.popupWindow == null || !this.popupWindow.isVisible()) {
            this.controller.invokeDropDown();
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (!aFlag) {
            this.popupWindow.setVisible(false);
        }
        super.setVisible(aFlag);
    }

    public Window getPopupWindow() {
        return this.popupWindow;
    }

    public boolean isPopupWindowVisible() {
        if (this.popupWindow == null) {
            return false;
        }
        return this.popupWindow.isVisible();
    }

    @Override
    public void setShapeCreator(ShapeCreator shapeCreator) {
    }
}

