/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.combobox.ComboBox;
import com.jmorgan.swing.combobox.ListComboBoxController;
import com.jmorgan.swing.list.ListModelFactory;
import com.jmorgan.util.DateMetaData;
import java.awt.Dimension;
import java.util.Calendar;
import javax.swing.JList;

public class WeekdayComboBox
extends ComboBox {
    private JList list = ((ListComboBoxController)this.getController()).getList();

    public WeekdayComboBox() {
        this(Calendar.getInstance().get(7));
    }

    public WeekdayComboBox(int day) {
        super(new ListComboBoxController());
        this.list.setModel(ListModelFactory.createListModel(DateMetaData.DAY_NAMES));
        this.list.setPrototypeCellValue("WEDNESDAY");
        this.setPreferredSize(new Dimension(80, 23));
        this.list.setSelectedIndex(day);
    }

    public String getWeekdayName() {
        return ((JMTextField)this.getController().getAttachToComponent()).getText();
    }

    public int getWeekDay() {
        return this.list.getSelectedIndex();
    }

    public void setWeekDay(String weekday) {
        this.setWeekDay(DateMetaData.getDayNumber(weekday));
    }

    public void setWeekDay(int weekday) {
        switch (weekday) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.list.setSelectedIndex(weekday);
            }
        }
    }
}

