/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.combobox;

import com.jmorgan.swing.JMList;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.combobox.ListComboBoxController;
import com.jmorgan.swing.list.ListModelFactory;
import com.jmorgan.util.ArrayFactory;
import java.awt.Dimension;
import java.util.Calendar;

public class YearComboBox
extends ListComboBox {
    private JMList list;
    private NumberField numberField;

    public YearComboBox() {
        super(new ListComboBoxController(new NumberField(5.0, "###0;-###0"), new JMList()));
        ListComboBoxController controller = (ListComboBoxController)this.getController();
        Calendar today = Calendar.getInstance();
        int year = today.get(1);
        this.list = (JMList)controller.getList();
        this.list.setModel(ListModelFactory.createListModel(ArrayFactory.createArray(ArrayFactory.createArray(year - 20, year + 19)), true));
        controller.setAllowEditing(true);
        controller.setToolTip("Select Year");
        this.setPreferredSize(new Dimension(100, 20));
        this.numberField = (NumberField)controller.getField();
        this.setYear(year);
    }

    public int getYear() {
        return (Integer)this.list.getSelectedValue();
    }

    public void setYear(int year) {
        this.list.setSelectedValue(new Integer(year), true);
        this.numberField.setNumber(year);
    }
}

