/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.border.RoundedCornerBorder;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.customizer.ColorCustomizer;
import com.jmorgan.swing.customizer.FontCustomizer;
import com.jmorgan.swing.customizer.IconCustomizer;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.layout.CellLayout;
import com.jmorgan.swing.layout.CellLayoutConstraints;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.util.InsetsFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JSeparator;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;

public class BorderCustomizer
extends AbstractCustomizer<Border, BorderCustomizer> {
    private boolean ignoreChanges = true;
    private ColorCustomizer borderColor;
    private ColorCustomizer borderShadow;
    private ColorCustomizer borderHighlightInner;
    private ColorCustomizer borderShadowInner;
    private JMRadioButton rbNone;
    private JMRadioButton rbEtched;
    private JMRadioButton rbBeveled;
    private JMRadioButton rbLine;
    private JMRadioButton rbMatte;
    private JMRadioButton rbRaised;
    private JMRadioButton rbLowered;
    private NumericalSliderComponent nfLeftWidth;
    private NumericalSliderComponent nfRightWidth;
    private NumericalSliderComponent nfTopWidth;
    private NumericalSliderComponent nfBottomWidth;
    private IconCustomizer matteIcon;
    private JMCheckBox cbxRounded;
    private NumericalSliderComponent nfCornerWidth;
    private JMCheckBox cbxTitle;
    private JMTextField tfTitle;
    private FontCustomizer titleFont;
    private ColorCustomizer titleColor;
    private JMRadioButton rbTitleJustifyLeft;
    private JMRadioButton rbTitleJustifyCenter;
    private JMRadioButton rbTitleJustifyRight;
    private JMRadioButton rbTitlePositionAboveTop;
    private JMRadioButton rbTitlePositionTop;
    private JMRadioButton rbTitlePositionBelowTop;
    private JMRadioButton rbTitlePositionAboveBottom;
    private JMRadioButton rbTitlePositionBottom;
    private JMRadioButton rbTitlePositionBelowBottom;

    public BorderCustomizer() {
        super(new BorderLayout());
        JMTabbedPane tabbedPane = new JMTabbedPane();
        tabbedPane.addTab("Style", this.createTypeTab());
        tabbedPane.addTab("Colors", this.createColorsTab());
        tabbedPane.addTab("Thickness", this.createLineThicknessTab());
        tabbedPane.addTab("Title Options", this.createTitleOptionsTab());
        this.add(tabbedPane);
        this.setEditor(this);
        this.ignoreChanges = false;
    }

    private JMPanel createTypeTab() {
        JMPanel outerPanel = new JMPanel(new VerticalFlowLayout(3));
        outerPanel.setInsets(InsetsFactory.createFixedInsets(5));
        JMPanel panel = new JMPanel(new CellLayout(2, 5, 5, 5));
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        this.rbNone = this.createRadioButton("&None");
        this.rbLine = this.createRadioButton("&Line", true);
        this.rbMatte = this.createRadioButton("&Matte");
        this.rbEtched = this.createRadioButton("&Etched");
        this.rbBeveled = this.createRadioButton("&Beveled");
        this.cbxTitle = new JMCheckBox("&Titled?", false);
        new ItemEventInvoker(this.cbxTitle, this, "createNewBorder");
        this.cbxRounded = new JMCheckBox("&Rounded", false);
        new ItemEventInvoker(this.cbxRounded, this, "createNewBorder");
        new JMButtonGroup(this.rbNone, this.rbLine, this.rbMatte, this.rbEtched, this.rbBeveled);
        this.rbRaised = this.createRadioButton("&Raised");
        this.rbLowered = this.createRadioButton("L&owered", true);
        new JMButtonGroup(this.rbRaised, this.rbLowered);
        panel.add((Component)this.rbNone, new CellLayoutConstraints(0, 0));
        panel.add((Component)this.rbLine, new CellLayoutConstraints(0, 1));
        panel.add((Component)this.rbMatte, new CellLayoutConstraints(0, 2));
        panel.add((Component)this.rbEtched, new CellLayoutConstraints(0, 3));
        panel.add((Component)this.rbBeveled, new CellLayoutConstraints(0, 4));
        panel.add((Component)this.cbxTitle, new CellLayoutConstraints(1, 0));
        panel.add((Component)this.cbxRounded, new CellLayoutConstraints(1, 1));
        panel.add((Component)this.rbRaised, new CellLayoutConstraints(1, 3));
        panel.add((Component)this.rbLowered, new CellLayoutConstraints(1, 4));
        outerPanel.add(panel);
        return outerPanel;
    }

    private JMPanel createColorsTab() {
        JMPanel panel = new JMPanel(new GridLayout(1, 4, 5, 5));
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        this.borderColor = this.createColorCustomizer("Border Color");
        this.borderShadow = this.createColorCustomizer("Bevel Outer Shadow");
        this.borderHighlightInner = this.createColorCustomizer("Bevel Highlight");
        this.borderShadowInner = this.createColorCustomizer("Bevel Inner Shadow");
        panel.add(this.borderColor);
        panel.add(this.borderShadow);
        panel.add(this.borderHighlightInner);
        panel.add(this.borderShadowInner);
        return panel;
    }

    private ColorCustomizer createColorCustomizer(String propertyName) {
        ColorCustomizer cc = new ColorCustomizer(Color.BLACK);
        cc.setPropertyName(propertyName);
        new PropertyChangeInvoker(cc, this, "createNewBorder");
        return cc;
    }

    private JMPanel createLineThicknessTab() {
        JMPanel panel = new JMPanel(new VerticalFlowLayout(3, 5));
        JMPanel thicknessPanel = new JMPanel(new VerticalFlowLayout(3, 5));
        thicknessPanel.setInsets(InsetsFactory.createFixedInsets(5));
        this.nfLeftWidth = this.createSliderComponent("&Left");
        this.nfRightWidth = this.createSliderComponent("&Right");
        this.nfTopWidth = this.createSliderComponent("&Top");
        this.nfBottomWidth = this.createSliderComponent("&Bottom");
        this.nfCornerWidth = this.createSliderComponent("&Corner Radius");
        thicknessPanel.add(this.nfLeftWidth);
        thicknessPanel.add(new JSeparator());
        thicknessPanel.add(this.nfRightWidth);
        thicknessPanel.add(new JSeparator());
        thicknessPanel.add(this.nfTopWidth);
        thicknessPanel.add(new JSeparator());
        thicknessPanel.add(this.nfBottomWidth);
        thicknessPanel.add(new JSeparator());
        thicknessPanel.add(this.nfCornerWidth);
        panel.add(thicknessPanel);
        this.matteIcon = new IconCustomizer();
        this.matteIcon.setPropertyName("Matte Icon");
        new PropertyChangeInvoker(this.matteIcon, this, "createNewBorder");
        panel.add(this.matteIcon);
        return panel;
    }

    private NumericalSliderComponent createSliderComponent(String label) {
        NumericalSliderComponent c = new NumericalSliderComponent(label, 1, 1, 100, 6);
        new PropertyChangeInvoker(c, this, "createNewBorder");
        return c;
    }

    private JMTabbedPane createTitleOptionsTab() {
        JMTabbedPane tabbedPane = new JMTabbedPane();
        JMPanel panel = new JMPanel(new VerticalFlowLayout(3));
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        this.tfTitle = new JMTextField("Border Title");
        new PropertyChangeInvoker(this.tfTitle, this, "createNewBorder");
        panel.add(new LabeledComponent("&Title", (Component)this.tfTitle));
        this.titleFont = new FontCustomizer();
        this.titleFont.setPropertyName("titleFont");
        new PropertyChangeInvoker(this.titleFont, this, "createNewBorder");
        panel.add(this.titleFont);
        tabbedPane.addTab("Text Options", panel);
        panel = new JMPanel(new BorderLayout());
        this.titleColor = new ColorCustomizer(Color.BLACK);
        this.titleColor.setPropertyName("titleColor");
        new PropertyChangeInvoker(this.titleColor, this, "createNewBorder");
        panel.add((Component)this.titleColor, "Center");
        tabbedPane.addTab("Color", panel);
        tabbedPane.addTab("Location", this.createTitleLocationPanel());
        return tabbedPane;
    }

    private JMPanel createTitleLocationPanel() {
        JMPanel panel = new JMPanel(new VerticalFlowLayout(3, 5));
        panel.setInsets(InsetsFactory.createFixedInsets(5));
        panel.add(this.createJustificationPanel());
        panel.add(this.createPositionPanel());
        return panel;
    }

    private JMPanel createJustificationPanel() {
        JMPanel panel = new JMPanel(new GridLayout(3, 1, 5, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Justification"));
        this.rbTitleJustifyLeft = this.createRadioButton("&Left", true);
        this.rbTitleJustifyCenter = this.createRadioButton("&Center");
        this.rbTitleJustifyRight = this.createRadioButton("&Right");
        new JMButtonGroup(this.rbTitleJustifyLeft, this.rbTitleJustifyCenter, this.rbTitleJustifyRight);
        panel.add(this.rbTitleJustifyLeft);
        panel.add(this.rbTitleJustifyCenter);
        panel.add(this.rbTitleJustifyRight);
        return panel;
    }

    private JMPanel createPositionPanel() {
        JMPanel panel = new JMPanel(new GridLayout(3, 1, 5, 5));
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Position"));
        this.rbTitlePositionAboveTop = this.createRadioButton("&Above Top Line");
        this.rbTitlePositionTop = this.createRadioButton("On &Top Line", true);
        this.rbTitlePositionBelowTop = this.createRadioButton("Belo&w Top Line");
        this.rbTitlePositionAboveBottom = this.createRadioButton("Abo&ve Bottom Line");
        this.rbTitlePositionBottom = this.createRadioButton("On &Bottom Line");
        this.rbTitlePositionBelowBottom = this.createRadioButton("Bel&ow Bottom Line");
        new JMButtonGroup(this.rbTitlePositionAboveTop, this.rbTitlePositionTop, this.rbTitlePositionBelowTop, this.rbTitlePositionAboveBottom, this.rbTitlePositionBottom, this.rbTitlePositionBelowBottom);
        panel.add(this.rbTitlePositionAboveTop);
        panel.add(this.rbTitlePositionAboveBottom);
        panel.add(this.rbTitlePositionTop);
        panel.add(this.rbTitlePositionBottom);
        panel.add(this.rbTitlePositionBelowTop);
        panel.add(this.rbTitlePositionBelowBottom);
        return panel;
    }

    private JMRadioButton createRadioButton(String label) {
        return this.createRadioButton(label, false);
    }

    private JMRadioButton createRadioButton(String label, boolean isSelected) {
        JMRadioButton rb = new JMRadioButton(label, isSelected);
        new ItemEventInvoker(rb, this, "createNewBorder");
        return rb;
    }

    public Border getBorderValue() {
        return (Border)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setBorderValue((Border)bean);
    }

    public void setBorderValue(Border border) {
        this.ignoreChanges = true;
        this.cbxTitle.setSelected(border instanceof TitledBorder);
        this.cbxRounded.setSelected(border instanceof RoundedCornerBorder);
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            this.tfTitle.setText(titledBorder.getTitle());
            this.titleColor.setColor(titledBorder.getTitleColor());
            this.titleFont.setFont(titledBorder.getTitleFont());
            int justification = titledBorder.getTitleJustification();
            switch (justification) {
                case 1: {
                    this.rbTitleJustifyLeft.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbTitleJustifyCenter.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbTitleJustifyRight.setSelected(true);
                }
            }
            int position = titledBorder.getTitlePosition();
            switch (position) {
                case 1: {
                    this.rbTitlePositionAboveTop.setSelected(true);
                    break;
                }
                case 2: {
                    this.rbTitlePositionTop.setSelected(true);
                    break;
                }
                case 3: {
                    this.rbTitlePositionBelowTop.setSelected(true);
                    break;
                }
                case 4: {
                    this.rbTitlePositionAboveBottom.setSelected(true);
                    break;
                }
                case 5: {
                    this.rbTitlePositionBottom.setSelected(true);
                    break;
                }
                case 6: {
                    this.rbTitlePositionBelowBottom.setSelected(true);
                }
            }
            border = titledBorder.getBorder();
        }
        if (border instanceof EmptyBorder) {
            this.rbNone.setSelected(true);
            EmptyBorder emptyBorder = (EmptyBorder)border;
            Insets insets = emptyBorder.getBorderInsets();
            this.nfLeftWidth.getNumberField().setNumber(insets.left);
            this.nfRightWidth.getNumberField().setNumber(insets.right);
            this.nfTopWidth.getNumberField().setNumber(insets.top);
            this.nfBottomWidth.getNumberField().setNumber(insets.bottom);
        } else if (border instanceof LineBorder) {
            this.rbLine.setSelected(true);
            LineBorder lineBorder = (LineBorder)border;
            this.borderColor.setColor(lineBorder.getLineColor());
            this.nfLeftWidth.getNumberField().setNumber(lineBorder.getThickness());
        } else if (border instanceof RoundedCornerBorder) {
            this.rbLine.setSelected(true);
            RoundedCornerBorder roundedBorder = (RoundedCornerBorder)border;
            this.nfCornerWidth.getNumberField().setNumber(roundedBorder.getCornerSize());
            this.borderColor.setColor(roundedBorder.getColor());
            this.nfLeftWidth.getNumberField().setNumber(roundedBorder.getThickness());
        } else if (border instanceof MatteBorder) {
            this.rbMatte.setSelected(true);
            MatteBorder matteBorder = (MatteBorder)border;
            this.borderColor.setColor(matteBorder.getMatteColor());
            this.matteIcon.setIcon(matteBorder.getTileIcon());
            Insets insets = matteBorder.getBorderInsets();
            this.nfLeftWidth.getNumberField().setNumber(insets.left);
            this.nfRightWidth.getNumberField().setNumber(insets.right);
            this.nfTopWidth.getNumberField().setNumber(insets.top);
            this.nfBottomWidth.getNumberField().setNumber(insets.bottom);
        } else if (border instanceof EtchedBorder) {
            this.rbEtched.setSelected(true);
            EtchedBorder etchedBorder = (EtchedBorder)border;
            int etchedType = etchedBorder.getEtchType();
            if (etchedType == 1) {
                this.rbLowered.setSelected(true);
            } else {
                this.rbRaised.setSelected(true);
            }
            this.borderColor.setColor(etchedBorder.getHighlightColor());
            this.borderShadow.setColor(etchedBorder.getShadowColor());
        } else if (border instanceof BevelBorder) {
            this.rbBeveled.setSelected(true);
            BevelBorder bevelBorder = (BevelBorder)border;
            int bevelType = bevelBorder.getBevelType();
            if (bevelType == 1) {
                this.rbLowered.setSelected(true);
            } else {
                this.rbRaised.setSelected(true);
            }
            this.borderColor.setColor(bevelBorder.getHighlightOuterColor());
            this.borderShadow.setColor(bevelBorder.getShadowOuterColor());
            this.borderHighlightInner.setColor(bevelBorder.getHighlightInnerColor());
            this.borderShadowInner.setColor(bevelBorder.getShadowInnerColor());
        }
        this.setEditorState();
        this.ignoreChanges = false;
        super.setObject(border);
    }

    @Reflected
    private void createNewBorder() {
        if (this.ignoreChanges) {
            return;
        }
        Border border = null;
        Color borderColor = this.borderColor.getColor();
        int lineThickness = (int)this.nfLeftWidth.getNumberField().getNumber();
        if (this.rbNone.isSelected()) {
            rightWidth = (int)this.nfRightWidth.getNumberField().getNumber();
            topWidth = (int)this.nfTopWidth.getNumberField().getNumber();
            int bottomWidth = (int)this.nfBottomWidth.getNumberField().getNumber();
            border = BorderFactory.createEmptyBorder(topWidth, lineThickness, bottomWidth, rightWidth);
        } else if (this.rbLine.isSelected()) {
            if (this.cbxRounded.isSelected()) {
                int cornerSize = (int)this.nfCornerWidth.getNumberField().getNumber();
                border = new RoundedCornerBorder(borderColor, 0, cornerSize, lineThickness);
            } else {
                border = BorderFactory.createLineBorder(borderColor, lineThickness);
            }
        } else if (this.rbMatte.isSelected()) {
            rightWidth = (int)this.nfRightWidth.getNumberField().getNumber();
            topWidth = (int)this.nfTopWidth.getNumberField().getNumber();
            int bottomWidth = (int)this.nfBottomWidth.getNumberField().getNumber();
            Icon matteIcon = this.matteIcon.getIcon();
            border = matteIcon != null ? BorderFactory.createMatteBorder(topWidth, lineThickness, bottomWidth, rightWidth, matteIcon) : BorderFactory.createMatteBorder(topWidth, lineThickness, bottomWidth, rightWidth, borderColor);
        } else {
            boolean isRaised = this.rbRaised.isSelected();
            boolean isLowered = this.rbLowered.isSelected();
            Color shadowColor = this.borderShadow.getColor();
            if (this.rbEtched.isSelected()) {
                border = BorderFactory.createEtchedBorder(isRaised ? 0 : 1, borderColor, shadowColor);
            } else if (this.rbBeveled.isSelected()) {
                Color innerHightlight = this.borderHighlightInner.getColor();
                Color innerShadow = this.borderShadowInner.getColor();
                border = BorderFactory.createBevelBorder(isRaised ? 0 : 1, borderColor, innerHightlight, shadowColor, innerShadow);
            }
        }
        boolean isTitled = this.cbxTitle.isSelected();
        if (isTitled) {
            String title = this.tfTitle.getText();
            Font titleFont = this.titleFont.getFontValue();
            Color titleColor = this.titleColor.getColor();
            int justification = 1;
            if (this.rbTitleJustifyLeft.isSelected()) {
                justification = 1;
            } else if (this.rbTitleJustifyCenter.isSelected()) {
                justification = 2;
            } else if (this.rbTitleJustifyRight.isSelected()) {
                justification = 3;
            }
            int position = 1;
            if (this.rbTitlePositionAboveTop.isSelected()) {
                position = 1;
            } else if (this.rbTitlePositionTop.isSelected()) {
                position = 2;
            } else if (this.rbTitlePositionBelowTop.isSelected()) {
                position = 3;
            } else if (this.rbTitlePositionAboveBottom.isSelected()) {
                position = 4;
            } else if (this.rbTitlePositionBottom.isSelected()) {
                position = 5;
            } else if (this.rbTitlePositionBelowBottom.isSelected()) {
                position = 6;
            }
            border = BorderFactory.createTitledBorder(border, title, justification, position, titleFont, titleColor);
        }
        this.setEditorState();
        super.setObject(border);
    }

    private void setEditorState() {
        boolean isNone = this.rbNone.isSelected();
        boolean isLine = this.rbLine.isSelected();
        boolean isMatte = this.rbMatte.isSelected();
        boolean isEtched = this.rbEtched.isSelected();
        boolean isBeveled = this.rbBeveled.isSelected();
        boolean isTitled = this.cbxTitle.isSelected();
        boolean isRounded = this.cbxRounded.isSelected();
        this.borderColor.setEnabled(!isNone);
        this.borderShadow.setEnabled(isEtched || isBeveled);
        this.borderHighlightInner.setEnabled(isBeveled);
        this.borderShadowInner.setEnabled(isBeveled);
        this.rbRaised.setEnabled(isEtched || isBeveled);
        this.rbLowered.setEnabled(isEtched || isBeveled);
        this.nfRightWidth.setEnabled(isNone || isMatte);
        this.nfTopWidth.setEnabled(isNone || isMatte);
        this.nfBottomWidth.setEnabled(isNone || isMatte);
        this.matteIcon.setEnabled(isMatte);
        this.cbxRounded.setEnabled(isLine);
        this.nfCornerWidth.setEnabled(isLine && isRounded);
        this.tfTitle.setEnabled(isTitled);
        this.titleFont.setEnabled(isTitled);
        this.titleColor.setEnabled(isTitled);
        this.rbTitleJustifyLeft.setEnabled(isTitled);
        this.rbTitleJustifyCenter.setEnabled(isTitled);
        this.rbTitleJustifyRight.setEnabled(isTitled);
        this.rbTitlePositionAboveTop.setEnabled(isTitled);
        this.rbTitlePositionTop.setEnabled(isTitled);
        this.rbTitlePositionBelowTop.setEnabled(isTitled);
        this.rbTitlePositionAboveBottom.setEnabled(isTitled);
        this.rbTitlePositionBottom.setEnabled(isTitled);
        this.rbTitlePositionBelowBottom.setEnabled(isTitled);
    }
}

