/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.customizer;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.component.NumericalSliderComponent;
import com.jmorgan.swing.customizer.AbstractCustomizer;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.comparator.CaseInsensitiveComparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import javax.swing.ListModel;

public class FontCustomizer
extends AbstractCustomizer<Font, Component[]> {
    private JMLabel fontNameLabel;
    private NumericalSliderComponent fontSize;
    private JMCheckBox cbxPlain;
    private JMCheckBox cbxBold;
    private JMCheckBox cbxItalic;
    private JMTextArea fontPreview;
    private JMList<String> fontList;
    private boolean ignoreChanges;

    public FontCustomizer() {
        this.setLayout(new BorderLayout(5, 5));
        this.ignoreChanges = false;
        this.fontNameLabel = new JMLabel("");
        this.fontSize = new NumericalSliderComponent("Font Size", 10, 1, 100, 6);
        new PropertyChangeInvoker(this.fontSize, this, "createNewFont");
        this.cbxPlain = this.createCheckbox("Plain");
        this.cbxBold = this.createCheckbox("Bold");
        this.cbxItalic = this.createCheckbox("Italic");
        JMPanel fontStylePanel = new JMPanel(new FlowLayout(0, 5, 1));
        fontStylePanel.add(this.cbxPlain);
        fontStylePanel.add(this.cbxBold);
        fontStylePanel.add(this.cbxItalic);
        this.fontPreview = new JMTextArea("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_=+[])_{};:'\",.<>/?\\|");
        this.fontPreview.setEditable(false);
        this.fontPreview.setPreferredSize(250, 200);
        JMPanel fontPropertiesPanel = new JMPanel(new VerticalFlowLayout(3, 5));
        fontPropertiesPanel.add(this.fontNameLabel);
        fontPropertiesPanel.add(this.fontSize);
        fontPropertiesPanel.add(fontStylePanel);
        fontPropertiesPanel.add(new JMScrollPane(this.fontPreview));
        this.fontList = new JMList<String>((ListModel<String>)FontCustomizer.loadFonts());
        new ListSelectionEventInvoker(this.fontList, this, "createNewFont");
        this.add((Component)new JMScrollPane(this.fontList), "West");
        this.add((Component)fontPropertiesPanel, "Center");
        this.setEditor(new Component[]{this.fontNameLabel, this.fontSize, this.cbxPlain, this.cbxBold, this.cbxItalic, this.fontList});
    }

    public FontCustomizer(Font font) {
        this();
        this.setFontValue(font);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.fontNameLabel.setEnabled(enabled);
        this.fontSize.setEnabled(enabled);
        this.cbxPlain.setEnabled(enabled);
        this.cbxBold.setEnabled(enabled);
        this.cbxItalic.setEnabled(enabled);
        this.fontPreview.setEnabled(enabled);
        this.fontList.setEnabled(enabled);
    }

    public Font getFontValue() {
        return (Font)this.getObject();
    }

    @Override
    public void setObject(Object bean) {
        this.setFontValue((Font)bean);
    }

    public void setFontValue(Font font) {
        this.fontNameLabel.setText("Font Name: " + font.getFontName());
        this.fontSize.setValue(font.getSize());
        this.cbxPlain.setSelected(font.isPlain());
        this.cbxBold.setSelected(font.isBold());
        this.cbxItalic.setSelected(font.isItalic());
        this.fontPreview.setFont(font);
        super.setObject(font);
    }

    private JMCheckBox createCheckbox(String label) {
        JMCheckBox cbx = new JMCheckBox(label);
        new ActionEventInvoker(cbx, this, "createNewFont");
        return cbx;
    }

    private static JMListModel<String> loadFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = ge.getAllFonts();
        String[] fontNames = new String[fonts.length];
        int i = 0;
        while (i < fontNames.length) {
            fontNames[i] = fonts[i].getFontName();
            ++i;
        }
        Arrays.sort(fontNames, new CaseInsensitiveComparator());
        JMListModel<String> model = new JMListModel<String>();
        model.addAll((Comparable[])fontNames);
        return model;
    }

    @Reflected
    private void createNewFont() {
        if (this.ignoreChanges) {
            return;
        }
        String fontName = (String)this.fontList.getSelectedValue();
        this.fontNameLabel.setText("Font Name: " + fontName);
        int fontSize = (int)this.fontSize.getValue();
        int plain = this.cbxPlain.isSelected() ? 0 : 0;
        int bold = this.cbxBold.isSelected() ? 1 : 0;
        int italic = this.cbxItalic.isSelected() ? 2 : 0;
        Font font = new Font(fontName, plain | bold | italic, fontSize);
        this.fontPreview.setFont(font);
        this.setObject(font);
    }
}

