/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.swing.decorator.IconDecorator;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImageIconDecorator
extends IconDecorator {
    private ImageIcon imageIcon;

    public ImageIconDecorator(ImageIcon icon) {
        this(icon, 0);
    }

    public ImageIconDecorator(ImageIcon icon, int padding) {
        super(padding);
        this.setImageIcon(icon);
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public void setImageIcon(ImageIcon imageIcon) {
        this.imageIcon = imageIcon;
    }

    @Override
    public void paint(Graphics graphics, JComponent component) {
        int padding = this.getPadding();
        Dimension newSize = new Dimension(component.getSize());
        newSize.width -= padding * 2;
        newSize.height -= padding * 2;
        graphics.drawImage(this.imageIcon.getImage(), padding, padding, newSize.width, newSize.height, component);
        component.paintComponents(graphics);
    }
}

