/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.decorator;

import com.jmorgan.swing.decorator.Decorator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class TOCDecorator
implements Decorator {
    private Color lineColor;
    private int lineThickness;
    private int lineSpacing;

    public TOCDecorator() {
        Color lineColor = UIManager.getColor("Button.foreground");
        this.setLineColor(lineColor);
        this.setLineThickness(3);
        this.setLineSpacing(12);
    }

    public TOCDecorator(Color lineColor, int lineThickness, int lineSpacing) {
        this.setLineColor(lineColor);
        this.setLineThickness(lineThickness);
        this.setLineSpacing(lineSpacing);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public void setLineThickness(int lineThickness) {
        this.lineThickness = lineThickness;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Dimension componentSize = component.getSize();
        int componentWidth = componentSize.width % 2 != 0 ? componentSize.width - 1 : componentSize.width;
        int componentHeight = componentSize.height % 2 != 0 ? componentSize.height - 1 : componentSize.height;
        Insets componentInsets = component.getInsets();
        Point center = new Point((componentWidth -= componentInsets.left - componentInsets.right) / 2, (componentHeight -= componentInsets.top - componentInsets.bottom) / 2);
        double halfLineThickness = (double)this.lineThickness / 2.0;
        double padding = (double)componentWidth * 0.2;
        double maxLineSpacing = (double)center.x - halfLineThickness - padding;
        if (maxLineSpacing > (double)this.lineSpacing) {
            maxLineSpacing = this.lineSpacing;
        }
        int left = (int)padding;
        int width = (int)((double)componentWidth - padding * 2.0 + 1.0);
        int arcSize = (int)halfLineThickness;
        g.setColor(this.lineColor);
        int i = 0;
        int y = (int)(padding + 1.0);
        while (i < 3) {
            g.fillRoundRect(left, y, width, this.lineThickness, arcSize, arcSize);
            ++i;
            y += (int)maxLineSpacing;
        }
    }
}

