/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.dnd;

import com.jmorgan.swing.dnd.FileDropHandlerListener;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.TransferHandler;

public class FileDropHandler
extends TransferHandler {
    private FileDropHandlerListener fileDropHandlerListener;

    public FileDropHandlerListener getFileDropHandlerListener() {
        return this.fileDropHandlerListener;
    }

    public void setFileDropHandlerListener(FileDropHandlerListener fileDropHandlerListener) {
        this.fileDropHandlerListener = fileDropHandlerListener;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        DataFlavor[] dataFlavorArray = support.getDataFlavors();
        int n = dataFlavorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataFlavor flavor = dataFlavorArray[n2];
            if (flavor.isFlavorJavaFileListType()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        if (this.fileDropHandlerListener != null) {
            try {
                List files = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                for (File file : files) {
                    this.fileDropHandlerListener.addDroppedFile(file);
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                return false;
            }
        }
        return true;
    }
}

