/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.event;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.AbstractMaskedEventInvoker;
import com.jmorgan.swing.event.MouseEventInvoker;
import java.util.EventObject;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnModelEventInvoker
extends AbstractMaskedEventInvoker<EventObject>
implements TableColumnModelListener {
    public static final int COLUMN_ADDED = 1;
    public static final int COLUMN_REMOVED = 2;
    public static final int COLUMN_MOVED = 4;
    public static final int COLUMN_SELECTION_CHANGED = 8;
    public static final int COLUMN_MARGIN_CHANGED = 16;
    private JTableHeader tableHeader;
    private boolean tableHeaderMouseDown;
    private int lastEventType;
    private EventObject lastEvent;
    private TableColumn resizedColumn;

    public ColumnModelEventInvoker(TableColumnModel eventProducer, int eventMask, Object target, String methodName) {
        super((Object)eventProducer, eventMask, target, methodName);
        this.setListenerAddRemoveMethodNames("addColumnModelListener", "removeColumnModelListener");
    }

    public ColumnModelEventInvoker(TableColumnModel eventProducer, int eventMask, Object target, String methodName, Object ... arguments) {
        super((Object)eventProducer, eventMask, target, methodName, arguments);
        this.setListenerAddRemoveMethodNames("addColumnModelListener", "removeColumnModelListener");
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            new MouseEventInvoker((Object)this.tableHeader, 8, this, "setMouseDown");
            new MouseEventInvoker((Object)this.tableHeader, 16, this, "setMouseUp");
        }
    }

    @Reflected
    private void setMouseDown() {
        this.tableHeaderMouseDown = true;
    }

    @Reflected
    private void setMouseUp() {
        this.tableHeaderMouseDown = false;
        switch (this.lastEventType) {
            case 4: {
                this.columnMoved((TableColumnModelEvent)this.lastEvent);
                break;
            }
            case 16: {
                ChangeEvent newEvent = new ChangeEvent(this.resizedColumn);
                this.columnMarginChanged(newEvent);
            }
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        this.setEvent(e);
        this.invokeForEvent(1);
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
        this.setEvent(e);
        this.invokeForEvent(2);
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (this.tableHeaderMouseDown) {
            this.lastEventType = 4;
            this.lastEvent = e;
            return;
        }
        this.setEvent(e);
        this.invokeForEvent(4);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        if (this.tableHeaderMouseDown) {
            this.lastEventType = 16;
            this.lastEvent = e;
            this.resizedColumn = this.tableHeader.getResizingColumn();
            return;
        }
        this.setEvent(e);
        this.invokeForEvent(16);
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        this.setEvent(e);
        this.invokeForEvent(8);
    }
}

