/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.event;

import com.jmorgan.beans.util.AbstractMaskedEventInvoker;
import java.util.regex.Pattern;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HyperlinkEventInvoker
extends AbstractMaskedEventInvoker<HyperlinkEvent>
implements HyperlinkListener {
    public static final int HYPERLINK_ENTERED = 1;
    public static final int HYPERLINK_EXITED = 2;
    public static final int HYPERLINK_ACTIVATED = 4;
    private String urlMatchPattern;

    public HyperlinkEventInvoker(Object eventProducer, int eventMask, Object target, String methodName) {
        super(eventProducer, eventMask, target, methodName);
        this.setListenerAddRemoveMethodNames("addHyperlinkListener", "removeHyperlinkListener");
        this.setUrlMatchPattern(".*");
    }

    public HyperlinkEventInvoker(Object eventProducer, int eventMask, Object target, String methodName, Object ... arguments) {
        super(eventProducer, eventMask, target, methodName, arguments);
        this.setListenerAddRemoveMethodNames("addHyperlinkListener", "removeHyperlinkListener");
        this.setUrlMatchPattern(".*");
    }

    public String getUrlMatchPattern() {
        return this.urlMatchPattern;
    }

    public void setUrlMatchPattern(String urlMatchPattern) {
        if (urlMatchPattern == null) {
            urlMatchPattern = ".*";
        }
        this.urlMatchPattern = urlMatchPattern;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        HyperlinkEvent.EventType et = e.getEventType();
        if (Pattern.matches(this.urlMatchPattern, e.getDescription())) {
            this.setEvent(e);
            if (et.equals(HyperlinkEvent.EventType.ENTERED)) {
                this.invokeForEvent(1);
            }
            if (et.equals(HyperlinkEvent.EventType.EXITED)) {
                this.invokeForEvent(2);
            }
            if (et.equals(HyperlinkEvent.EventType.ACTIVATED)) {
                this.invokeForEvent(4);
            }
        }
    }
}

