/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.layout;

import java.awt.Dimension;
import java.awt.Point;

public class XYLayoutConstraints {
    private int x;
    private int y;
    private int width;
    private int height;

    public XYLayoutConstraints() {
        this(0, 0, 10, 10);
    }

    public XYLayoutConstraints(Point location) throws IllegalArgumentException {
        this(location, 10, 10);
    }

    public XYLayoutConstraints(int x, int y) throws IllegalArgumentException {
        this(x, y, 10, 10);
    }

    public XYLayoutConstraints(int x, int y, int width, int height) throws IllegalArgumentException {
        this.setConstraints(x, y, width, height);
    }

    public XYLayoutConstraints(int x, int y, Dimension size) throws IllegalArgumentException {
        this.setX(x);
        this.setY(y);
        this.setSize(size);
    }

    public XYLayoutConstraints(Point location, int width, int height) throws IllegalArgumentException {
        this.setLocation(location);
        this.setConstraints(location.x, location.y, width, height);
    }

    public XYLayoutConstraints(Point location, Dimension size) throws IllegalArgumentException {
        this.setLocation(location);
        this.setSize(size);
    }

    public void setConstraints(int x, int y, int width, int height) throws IllegalArgumentException {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void setLocation(Point location) throws IllegalArgumentException {
        if (location == null) {
            throw new IllegalArgumentException("The location is not allowed to be null.");
        }
        this.setX(location.x);
        this.setY(location.y);
    }

    public void setSize(Dimension size) throws IllegalArgumentException {
        if (size == null) {
            throw new IllegalArgumentException("The size is not allowed to be null.");
        }
        this.setWidth(size.width);
        this.setHeight(size.height);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("x cannot be less than 0.");
        }
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("y cannot be less than 0.");
        }
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than 0.");
        }
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than 0.");
        }
        this.height = height;
    }
}

