/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.list.DefaultListCellValueRenderer;
import com.jmorgan.swing.list.ListCellValueRenderer;
import com.jmorgan.swing.util.ComponentConstants;
import com.jmorgan.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JMListCellRenderer<BeanType>
implements ListCellRenderer<BeanType> {
    private static final boolean COLOR_TYPE_FOREGROUND = true;
    private static final boolean COLOR_TYPE_BACKGROUND = false;
    private ListCellValueRenderer valueRenderer;
    private JList<BeanType> activeList;
    private int index;
    private ArrayList<Pair<PropertyValueRule<BeanType>, Color>> selectedColorRules;
    private ArrayList<Pair<PropertyValueRule<BeanType>, Color>> unSelectedColorRules;
    private ArrayList<Pair<PropertyValueRule<BeanType>, Color>> selectedBackgroundColorRules;
    private ArrayList<Pair<PropertyValueRule<BeanType>, Color>> unSelectedBackgroundColorRules;
    private ArrayList<Pair<PropertyValueRule<BeanType>, Font>> selectedFontRules;
    private ArrayList<Pair<PropertyValueRule<BeanType>, Font>> unSelectedFontRules;
    private Border selectedBorder;
    private Border unSelectedBorder;

    public JMListCellRenderer() {
        this(new DefaultListCellValueRenderer());
    }

    public JMListCellRenderer(ListCellValueRenderer valueRenderer) {
        this(valueRenderer, UIManager.getColor("List.selectionForeground"), UIManager.getColor("List.selectionBackground"), UIManager.getColor("List.foreground"), UIManager.getColor("List.background"));
    }

    public JMListCellRenderer(Color selectedColor, Color selectedBackground, Color unSelectedColor, Color unSelectedBackground) {
        this(new DefaultListCellValueRenderer(), selectedColor, selectedBackground, unSelectedColor, unSelectedBackground);
    }

    public JMListCellRenderer(ListCellValueRenderer valueRenderer, Color selectedColor, Color selectedBackground, Color unSelectedColor, Color unSelectedBackground) {
        this.setValueRenderer(valueRenderer);
        this.selectedColorRules = new ArrayList();
        this.unSelectedColorRules = new ArrayList();
        this.selectedBackgroundColorRules = new ArrayList();
        this.unSelectedBackgroundColorRules = new ArrayList();
        this.selectedFontRules = new ArrayList();
        this.unSelectedFontRules = new ArrayList();
        this.setSelectedBorder(ComponentConstants.listSelectedBorder);
        this.setUnSelectedBorder(ComponentConstants.listNormalBorder);
        this.setSelectedColor(selectedColor);
        this.setUnSelectedColor(unSelectedColor);
        this.setSelectedBackground(selectedBackground);
        this.setUnSelectedBackground(unSelectedBackground);
        this.setSelectedFont(UIManager.getFont("Label.font"));
        this.setUnSelectedFont(UIManager.getFont("Label.font"));
    }

    public JList<BeanType> getActiveList() {
        return this.activeList;
    }

    public int getIndex() {
        return this.index;
    }

    public ListCellValueRenderer getValueRenderer() {
        return this.valueRenderer;
    }

    public void setValueRenderer(ListCellValueRenderer valueRenderer) {
        this.valueRenderer = valueRenderer == null ? new DefaultListCellValueRenderer() : valueRenderer;
    }

    public Color getSelectedColor() {
        return this.getDefaultColor(this.selectedColorRules);
    }

    public void setSelectedColor(Color selectedColor) {
        this.setDefaultColor(this.selectedColorRules, selectedColor);
    }

    public Color getSelectedBackground() {
        return this.getDefaultColor(this.selectedBackgroundColorRules);
    }

    public void setSelectedBackground(Color selectedBackground) {
        this.setDefaultColor(this.selectedBackgroundColorRules, selectedBackground);
        JComponent renderer = this.valueRenderer.getComponent();
        renderer.setOpaque(true);
    }

    public Color getUnSelectedColor() {
        return this.getDefaultColor(this.unSelectedColorRules);
    }

    public void setUnSelectedColor(Color unSelectedColor) {
        this.setDefaultColor(this.unSelectedColorRules, unSelectedColor);
    }

    public Color getUnSelectedBackground() {
        return this.getDefaultColor(this.unSelectedBackgroundColorRules);
    }

    public void setUnSelectedBackground(Color unSelectedBackground) {
        this.setDefaultColor(this.unSelectedBackgroundColorRules, unSelectedBackground);
        JComponent renderer = this.valueRenderer.getComponent();
        renderer.setOpaque(true);
    }

    public Border getSelectedBorder() {
        return this.selectedBorder;
    }

    public void setSelectedBorder(Border selectedBorder) {
        this.selectedBorder = selectedBorder;
    }

    public Border getUnSelectedBorder() {
        return this.unSelectedBorder;
    }

    public void setUnSelectedBorder(Border unSelectedBorder) {
        this.unSelectedBorder = unSelectedBorder;
    }

    private Color getDefaultColor(ArrayList<Pair<PropertyValueRule<BeanType>, Color>> ruleSet) {
        Pair<PropertyValueRule<BeanType>, Color> rule = this.getDefaultColorRule(ruleSet);
        if (rule != null) {
            return (Color)rule.second;
        }
        return null;
    }

    private void setDefaultColor(ArrayList<Pair<PropertyValueRule<BeanType>, Color>> ruleSet, Color color) {
        Pair<PropertyValueRule<BeanType>, Color> rule = this.getDefaultColorRule(ruleSet);
        if (rule != null) {
            rule.second = color;
        } else {
            ruleSet.add(new Pair<Object, Color>(null, color));
        }
    }

    private Pair<PropertyValueRule<BeanType>, Color> getDefaultColorRule(ArrayList<Pair<PropertyValueRule<BeanType>, Color>> ruleSet) {
        for (Pair<PropertyValueRule<BeanType>, Color> rule : ruleSet) {
            if (rule.first != null) continue;
            return rule;
        }
        return null;
    }

    public void addSelectedColorRule(PropertyValueRule<BeanType> rule, Color color) {
        this.addColorRule(this.selectedColorRules, rule, color);
    }

    public void addSelectedBackgroundColorRule(PropertyValueRule<BeanType> rule, Color color) {
        this.addColorRule(this.selectedBackgroundColorRules, rule, color);
    }

    public void addUnSelectedColorRule(PropertyValueRule<BeanType> rule, Color color) {
        this.addColorRule(this.unSelectedColorRules, rule, color);
    }

    public void addUnSelectedBackgroundColorRule(PropertyValueRule<BeanType> rule, Color color) {
        this.addColorRule(this.unSelectedBackgroundColorRules, rule, color);
    }

    private void addColorRule(ArrayList<Pair<PropertyValueRule<BeanType>, Color>> ruleSet, PropertyValueRule<BeanType> rule, Color color) {
        Pair<PropertyValueRule<BeanType>, Color> ruleMap = new Pair<PropertyValueRule<BeanType>, Color>(rule, color);
        ruleSet.add(ruleMap);
    }

    public Font getSelectedFont() {
        return this.getDefaultFont(this.selectedFontRules);
    }

    public void setUnSelectedFont(Font selectedFont) {
        this.setDefaultFont(this.unSelectedFontRules, selectedFont);
    }

    public Font getUnSelectedFont() {
        return this.getDefaultFont(this.unSelectedFontRules);
    }

    public void setSelectedFont(Font selectedFont) {
        this.setDefaultFont(this.selectedFontRules, selectedFont);
    }

    private Font getDefaultFont(ArrayList<Pair<PropertyValueRule<BeanType>, Font>> ruleSet) {
        Pair<PropertyValueRule<BeanType>, Font> rule = this.getDefaultFontRule(ruleSet);
        if (rule != null) {
            return (Font)rule.second;
        }
        return null;
    }

    private void setDefaultFont(ArrayList<Pair<PropertyValueRule<BeanType>, Font>> ruleSet, Font font) {
        Pair<PropertyValueRule<BeanType>, Font> rule = this.getDefaultFontRule(ruleSet);
        if (rule != null) {
            rule.second = font;
        } else {
            ruleSet.add(new Pair<Object, Font>(null, font));
        }
    }

    private Pair<PropertyValueRule<BeanType>, Font> getDefaultFontRule(ArrayList<Pair<PropertyValueRule<BeanType>, Font>> ruleSet) {
        for (Pair<PropertyValueRule<BeanType>, Font> rule : ruleSet) {
            if (rule.first != null) continue;
            return rule;
        }
        return null;
    }

    public void addSelectedFontRule(PropertyValueRule<BeanType> rule, Font font) {
        if (this.selectedFontRules == null) {
            this.selectedFontRules = new ArrayList();
        }
        this.addFontRule(this.selectedFontRules, rule, font);
    }

    public void addUnSelectedFontRule(PropertyValueRule<BeanType> rule, Font font) {
        if (this.unSelectedFontRules == null) {
            this.unSelectedFontRules = new ArrayList();
        }
        this.addFontRule(this.unSelectedFontRules, rule, font);
    }

    private void addFontRule(ArrayList<Pair<PropertyValueRule<BeanType>, Font>> ruleSet, PropertyValueRule<BeanType> rule, Font font) {
        Pair<PropertyValueRule<BeanType>, Font> ruleMap = new Pair<PropertyValueRule<BeanType>, Font>(rule, font);
        ruleSet.add(ruleMap);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends BeanType> list, BeanType value, int index, boolean isSelected, boolean cellHasFocus) {
        this.activeList = list;
        this.index = index;
        return isSelected ? this.select(list, value, index) : this.unSelect(list, value, index);
    }

    public Component select(JList<?> list, Object value, int index) {
        JComponent renderComponent = this.valueRenderer.getComponent();
        if (this.selectedBorder != null) {
            renderComponent.setBorder(this.selectedBorder);
        }
        Object bean = value;
        this.applyColorRule(this.selectedColorRules, bean, true);
        this.applyColorRule(this.selectedBackgroundColorRules, bean, false);
        this.applyFontRule(this.selectedFontRules, bean);
        this.valueRenderer.renderValueToComponent(value, true);
        return renderComponent;
    }

    public Component unSelect(JList<?> list, Object value, int index) {
        JComponent renderComponent = this.valueRenderer.getComponent();
        if (this.unSelectedBorder != null) {
            renderComponent.setBorder(this.unSelectedBorder);
        }
        Object bean = value;
        this.applyColorRule(this.unSelectedColorRules, bean, true);
        this.applyColorRule(this.unSelectedBackgroundColorRules, bean, false);
        this.applyFontRule(this.unSelectedFontRules, bean);
        this.valueRenderer.renderValueToComponent(value, false);
        return renderComponent;
    }

    private boolean applyColorRule(ArrayList<Pair<PropertyValueRule<BeanType>, Color>> ruleSet, BeanType bean, boolean colorType) {
        JComponent renderComponent = this.valueRenderer.getComponent();
        if (!colorType) {
            renderComponent.setOpaque(true);
        }
        boolean ruleApplied = false;
        for (Pair<PropertyValueRule<BeanType>, Color> rule : ruleSet) {
            if (rule.first == null) continue;
            ((PropertyValueRule)rule.first).setBean(bean);
            if (!((PropertyValueRule)rule.first).isTrue()) continue;
            if (colorType) {
                renderComponent.setForeground((Color)rule.second);
            } else {
                renderComponent.setBackground((Color)rule.second);
            }
            ruleApplied = true;
            break;
        }
        if (!ruleApplied) {
            if (colorType) {
                renderComponent.setForeground(this.getDefaultColor(ruleSet));
            } else {
                renderComponent.setBackground(this.getDefaultColor(ruleSet));
            }
        }
        return ruleApplied;
    }

    private boolean applyFontRule(ArrayList<Pair<PropertyValueRule<BeanType>, Font>> ruleSet, BeanType bean) {
        if (ruleSet == null) {
            return false;
        }
        JComponent renderComponent = this.valueRenderer.getComponent();
        boolean ruleApplied = false;
        for (Pair<PropertyValueRule<BeanType>, Font> rule : ruleSet) {
            if (rule.first == null) continue;
            ((PropertyValueRule)rule.first).setBean(bean);
            if (!((PropertyValueRule)rule.first).isTrue()) continue;
            renderComponent.setFont((Font)rule.second);
            ruleApplied = true;
            break;
        }
        if (!ruleApplied) {
            renderComponent.setFont(this.getDefaultFont(ruleSet));
        }
        return ruleApplied;
    }
}

