/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.swing.list.PropertyValueListElementSelector;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JList;

public class KeySearchListElementSelector<ListElementType>
extends PropertyValueListElementSelector<ListElementType>
implements KeyListener {
    private String propertyNameExpression;
    private StringBuilder keyBuffer;
    private int bufferTimeout;
    private long lastKeyTime;

    public KeySearchListElementSelector(JList<ListElementType> list, String propertyNameExpression) {
        this(list, propertyNameExpression, 2000);
    }

    public KeySearchListElementSelector(JList<ListElementType> list, String propertyNameExpression, int bufferTimeout) {
        super(list);
        this.setCaseSensitiveSearch(false);
        this.setPropertyNameExpression(propertyNameExpression);
        this.setAutoSelectOnRuleChanges(true);
        this.setBufferTimeout(bufferTimeout);
        this.keyBuffer = new StringBuilder();
        list.addKeyListener(this);
    }

    public String getPropertyNameExpression() {
        return this.propertyNameExpression;
    }

    public void setPropertyNameExpression(String propertyNameExpression) {
        this.propertyNameExpression = propertyNameExpression;
    }

    public int getBufferTimeout() {
        return this.bufferTimeout;
    }

    public void setBufferTimeout(int bufferTimeout) {
        this.bufferTimeout = bufferTimeout;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        long now = System.currentTimeMillis();
        long timeElapsed = now - this.lastKeyTime;
        if (timeElapsed > (long)this.bufferTimeout) {
            this.keyBuffer.setLength(0);
        }
        this.lastKeyTime = now;
        char ch = e.getKeyChar();
        if (!this.isCaseSensitiveSearch()) {
            this.keyBuffer.append("[");
        }
        this.keyBuffer.append(ch);
        String searchPattern = null;
        if (!this.isCaseSensitiveSearch()) {
            this.keyBuffer.append(Character.isUpperCase(ch) ? Character.toLowerCase(ch) : Character.toUpperCase(ch));
            this.keyBuffer.append("]");
            searchPattern = String.format("%s.*", this.keyBuffer.toString());
        } else {
            searchPattern = this.keyBuffer.toString();
        }
        this.addPropertyValueMap(this.propertyNameExpression, searchPattern, 11);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

