/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.swing.list.DefaultListCellValueRenderer;
import java.util.HashMap;
import javax.swing.Icon;

public class MappedListCellValueRenderer<ListCellValueType>
extends DefaultListCellValueRenderer {
    private HashMap<ListCellValueType, String> displayMap;

    public MappedListCellValueRenderer() {
        this.displayMap = new HashMap();
    }

    public MappedListCellValueRenderer(HashMap<ListCellValueType, String> displayMap) {
        this.setDisplayMap(displayMap);
    }

    public MappedListCellValueRenderer(Icon image) {
        super(image);
        this.displayMap = new HashMap();
    }

    public MappedListCellValueRenderer(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.displayMap = new HashMap();
    }

    public HashMap<ListCellValueType, String> getDisplayMap() {
        return this.displayMap;
    }

    public void setDisplayMap(HashMap<ListCellValueType, String> displayMap) {
        if (this.displayMap == null) {
            this.displayMap = displayMap;
        } else {
            this.displayMap.putAll(displayMap);
        }
    }

    public void addMappedValue(ListCellValueType value, String displayValue) {
        this.displayMap.put(value, displayValue);
    }

    public void removeMappedValue(ListCellValueType value) {
        this.displayMap.remove(value);
    }

    @Override
    public void renderValueToComponent(Object value, boolean isSelected) {
        if (value == null) {
            super.renderValueToComponent(value, isSelected);
        } else {
            String displayValue = this.displayMap.get(value);
            super.renderValueToComponent(displayValue == null ? value : displayValue, isSelected);
        }
    }
}

