/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.swing.list.AbstractTypedListElementSelector;
import com.jmorgan.util.collection.PropertyValueSelector;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;

public class PropertyValueListElementSelector<ListElementType>
extends AbstractTypedListElementSelector<ListElementType> {
    private PropertyValueSelector<ListElementType> propertyValueSelector;
    private ArrayList<ListElementType> elements = new ArrayList();
    private boolean caseSensitiveSearch;

    public PropertyValueListElementSelector(JList<ListElementType> list) {
        super(list);
        this.propertyValueSelector = new PropertyValueSelector<ListElementType>(this.elements);
    }

    public void addPropertyValueMap(String propertyName, Object value) {
        this.propertyValueSelector.addPropertyValueMap(propertyName, value);
        if (this.getAutoSelectOnRuleChanges()) {
            this.selectElements();
        }
    }

    public void addPropertyValueMap(String propertyName, Object value, int comparisonType) {
        this.propertyValueSelector.addPropertyValueMap(propertyName, value, comparisonType);
        if (this.getAutoSelectOnRuleChanges()) {
            this.selectElements();
        }
    }

    public void clearMap() {
        this.propertyValueSelector.clearMap();
        if (this.getAutoSelectOnRuleChanges()) {
            this.selectElements();
        }
    }

    public void removePropertyValueMap(String propertyName) {
        this.propertyValueSelector.removePropertyValueMap(propertyName);
        if (this.getAutoSelectOnRuleChanges()) {
            this.selectElements();
        }
    }

    @Override
    public int selectElements() {
        JList list = this.getList();
        ListModel listModel = list.getModel();
        int listSize = listModel.getSize();
        if (listSize == 0) {
            return 0;
        }
        ListSelectionModel selectionModel = list.getSelectionModel();
        int i = 0;
        while (i < listSize) {
            this.elements.add(listModel.getElementAt(i));
            ++i;
        }
        Collection selectedElements = this.propertyValueSelector.getSelectedElements();
        int selectionSize = selectedElements.size();
        if (selectionSize == 0) {
            return 0;
        }
        if (selectionModel.getSelectionMode() == 0) {
            selectionSize = 1;
        }
        int[] selectionIndicies = new int[selectionSize];
        int si = 0;
        block1: for (Object elementToSelect : selectedElements) {
            int i2 = 0;
            while (i2 < listSize) {
                Object element = listModel.getElementAt(i2);
                if (element.equals(elementToSelect)) {
                    selectionIndicies[si++] = i2;
                    if (selectionModel.getSelectionMode() == 0) break block1;
                }
                ++i2;
            }
        }
        list.setSelectedIndices(selectionIndicies);
        list.ensureIndexIsVisible(selectionIndicies[0]);
        this.elements.clear();
        return selectedElements.size();
    }

    public boolean isCaseSensitiveSearch() {
        return this.caseSensitiveSearch;
    }

    public void setCaseSensitiveSearch(boolean caseSensitiveSearch) {
        this.caseSensitiveSearch = caseSensitiveSearch;
    }
}

