/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.list;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.list.DefaultListCellValueRenderer;
import javax.swing.Icon;

public class SimpleBeanListCellValueRenderer
extends DefaultListCellValueRenderer {
    private String beanDisplayPropertyName;

    public SimpleBeanListCellValueRenderer(String beanDisplayPropertyName) {
        this.setBeanDisplayPropertyName(beanDisplayPropertyName);
    }

    public SimpleBeanListCellValueRenderer(String beanDisplayPropertyName, Icon image) {
        super(image);
        this.setBeanDisplayPropertyName(beanDisplayPropertyName);
    }

    public SimpleBeanListCellValueRenderer(String beanDisplayPropertyName, Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.setBeanDisplayPropertyName(beanDisplayPropertyName);
    }

    public String getBeanDisplayPropertyName() {
        return this.beanDisplayPropertyName;
    }

    public void setBeanDisplayPropertyName(String beanDisplayPropertyName) {
        this.beanDisplayPropertyName = beanDisplayPropertyName;
    }

    @Override
    public void renderValueToComponent(Object value, boolean isSelected) {
        if (value == null) {
            this.setText(this.getNullRenderValue());
            return;
        }
        Object displayValue = BeanService.getPropertyValue(value, this.beanDisplayPropertyName);
        super.renderValueToComponent(displayValue, isSelected);
    }
}

