/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.menu;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.MouseEventInvoker;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.menu.MenuGroup;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.util.InsetsFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JMPopupMenu
extends JPopupMenu {
    private HashMap<String, MenuGroup> menuGroups;
    private ArrayList<Component> popupMenuClients;
    private ArrayList<MouseEventInvoker> eventHandlers;
    private PopupMenuController popupController;

    public JMPopupMenu() {
    }

    public JMPopupMenu(String label) {
        super(label);
    }

    public JMPopupMenu(Component popupMenuClient) {
        this();
        this.addPopupMenuClient(popupMenuClient);
    }

    public JMPopupMenu(String label, Component popupMenuClient) {
        this(label);
        this.addPopupMenuClient(popupMenuClient);
    }

    public PopupMenuController getPopupController() {
        return this.popupController;
    }

    public void setPopupController(PopupMenuController popupController) {
        this.popupController = popupController;
    }

    public ArrayList<Component> getPopupMenuClients() {
        return this.popupMenuClients;
    }

    public void addPopupMenuClient(Component popupMenuClient) {
        if (popupMenuClient == null) {
            return;
        }
        if (this.popupMenuClients == null) {
            this.popupMenuClients = new ArrayList();
            this.eventHandlers = new ArrayList();
        }
        this.popupMenuClients.add(popupMenuClient);
        MouseEventInvoker eventHandler = new MouseEventInvoker((Object)popupMenuClient, 16, this, "showPopup", popupMenuClient);
        this.eventHandlers.add(eventHandler);
    }

    public void removePopupClient(Component popupMenuClient) {
        if (popupMenuClient == null) {
            return;
        }
        int popupMenuClientIndex = this.popupMenuClients.indexOf(popupMenuClient);
        if (popupMenuClientIndex >= 0) {
            this.popupMenuClients.remove(popupMenuClientIndex);
            MouseEventInvoker eventHandler = this.eventHandlers.get(popupMenuClientIndex);
            eventHandler.setEventProducer(null);
            this.eventHandlers.remove(popupMenuClientIndex);
        }
    }

    public MenuGroup getMenuGroup(String name) {
        return this.menuGroups.get(name);
    }

    public void addMenuGroup(String name, MenuGroup menuGroup) {
        if (this.menuGroups == null) {
            this.menuGroups = new HashMap();
        }
        this.menuGroups.put(name, menuGroup);
        for (JComponent menuComponent : menuGroup.getMenuComponents()) {
            this.add(menuComponent);
        }
    }

    public JMenuItem addMenuItem(String label, Object eventTarget, String eventMethodName) {
        JMMenuItem menuItem = new JMMenuItem(label);
        return this.addMenuItem(menuItem, eventTarget, eventMethodName);
    }

    public JMenuItem addMenuItem(String label, Object eventTarget, String eventMethodName, Object ... methodArguments) {
        JMMenuItem menuItem = new JMMenuItem(label);
        return this.addMenuItem(menuItem, eventTarget, eventMethodName, methodArguments);
    }

    public JMenuItem addMenuItem(Icon icon, Object eventTarget, String eventMethodName) {
        JMMenuItem menuItem = new JMMenuItem(icon);
        return this.addMenuItem(menuItem, eventTarget, eventMethodName);
    }

    public JMenuItem addMenuItem(String label, Icon icon, Object eventTarget, String eventMethodName) {
        JMMenuItem menuItem = new JMMenuItem(label, icon);
        return this.addMenuItem(menuItem, eventTarget, eventMethodName);
    }

    public JMenuItem addMenuItem(JMenuItem menuItem, Object eventTarget, String eventMethodName) {
        return this.addMenuItem(menuItem, eventTarget, eventMethodName, null);
    }

    public JMenuItem addMenuItem(JMenuItem menuItem, Object eventTarget, String eventMethodName, Object ... methodArguments) {
        if (methodArguments == null) {
            new ActionEventInvoker(menuItem, eventTarget, eventMethodName);
        } else {
            new ActionEventInvoker(menuItem, eventTarget, eventMethodName, methodArguments);
        }
        JMenuItem itemAdded = this.add(menuItem);
        JMPopupMenu.forceMenuItemSize(itemAdded);
        return itemAdded;
    }

    public static void forceMenuItemSize(JMenuItem menuItem) {
        menuItem.setMargin(InsetsFactory.createFixedInsets(2));
        Dimension preferredSize = menuItem.getPreferredSize();
        menuItem.setPreferredSize(new Dimension(preferredSize.width, 20));
        menuItem.setSize(new Dimension(preferredSize.width, 20));
    }

    public void setMenuItemEnabled(String labelMatchExpression, boolean enabledState) {
        int cc = this.getComponentCount();
        int c = 0;
        while (c < cc) {
            String menuItemName;
            Component component = this.getComponent(c);
            if ((component instanceof JMMenuItem || component instanceof JMenu) && (menuItemName = (String)BeanService.getPropertyValue(component, "name")).matches(labelMatchExpression)) {
                BeanService.setPropertyValue(component, "enabled", enabledState);
            }
            ++c;
        }
    }

    public void setMenuItemVisible(String labelMatchExpression, boolean visibleState) {
        int cc = this.getComponentCount();
        int c = 0;
        while (c < cc) {
            String menuItemName;
            Component component = this.getComponent(c);
            if ((component instanceof JMMenuItem || component instanceof JMenu) && (menuItemName = (String)BeanService.getPropertyValue(component, "name")).matches(labelMatchExpression)) {
                BeanService.setPropertyValue(component, "visible", visibleState);
            }
            ++c;
        }
    }

    @Reflected
    private void showPopup(Component target) {
        int index = this.popupMenuClients.indexOf(target);
        if (index == -1) {
            System.err.printf("JMPopupMenu.showPopup(target=%s): Component not in popup menu clients\n", target.getClass().getName());
            return;
        }
        MouseEventInvoker eventHandler = this.eventHandlers.get(index);
        MouseEvent me = (MouseEvent)eventHandler.getEvent();
        if ((me.isPopupTrigger() || SwingUtilities.isRightMouseButton(me)) && !this.isShowing()) {
            boolean showPopup = true;
            if (this.popupController != null) {
                showPopup = this.popupController.isPopupReady();
            }
            if (showPopup) {
                this.show(me.getComponent(), me.getX(), me.getY());
            }
        }
    }
}

