/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.spinner;

import com.jmorgan.swing.DateField;
import com.jmorgan.swing.spinner.SpinEvent;
import com.jmorgan.swing.spinner.SpinListener;
import com.jmorgan.swing.spinner.Spinner;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringIndexer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;

public class DateSpinner
extends Spinner
implements SpinListener,
PropertyChangeListener {
    private int[] dayFields;
    private int[] monthFields;
    private int[] yearFields;

    public DateSpinner(DateField df) {
        super(df);
        this.addSpinListener(this);
        this.indexDateFields(df.getFormatString());
    }

    @Override
    public void spinUp(SpinEvent e) {
        this.spin(e);
    }

    @Override
    public void spinDown(SpinEvent e) {
        this.spin(e);
    }

    private void spin(SpinEvent e) {
        DateField df = (DateField)e.getSource();
        if (df.isNull()) {
            return;
        }
        Calendar thisDate = df.getDate();
        if (thisDate == null) {
            return;
        }
        this.oldValue = thisDate.clone();
        int caretPos = df.getCaretPosition();
        int spinDir = e.getSpinDirection() == 1 ? -1 : 1;
        boolean inSpinRange = false;
        int direction = caretPos == 0 ? 1 : -1;
        int location = caretPos;
        while (!inSpinRange) {
            if (Comparison.isIn(location, this.yearFields)) {
                thisDate.add(1, spinDir);
                inSpinRange = true;
            } else if (Comparison.isIn(location, this.dayFields)) {
                thisDate.add(5, spinDir);
                inSpinRange = true;
            } else if (Comparison.isIn(location, this.monthFields)) {
                thisDate.add(2, spinDir);
                inSpinRange = true;
            }
            if (inSpinRange) continue;
            location += direction;
        }
        this.newValue = thisDate.clone();
        df.setDate(thisDate);
        df.requestFocus();
        df.setCaretPosition(caretPos);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("formatString")) {
            this.indexDateFields((String)evt.getNewValue());
        }
    }

    private void indexDateFields(String formatString) {
        if (formatString == null) {
            return;
        }
        this.dayFields = StringIndexer.indexCharacter(formatString, 'd');
        this.monthFields = StringIndexer.indexCharacter(formatString, 'M');
        this.yearFields = StringIndexer.indexCharacter(formatString, 'y');
    }
}

