/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.spinner;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.swing.spinner.SpinEvent;
import com.jmorgan.swing.spinner.SpinListener;
import com.jmorgan.swing.spinner.Spinner;
import java.awt.Component;
import java.util.List;

public class ListSpinner<LT>
extends Spinner
implements SpinListener {
    private int currentIndex;
    private List<LT> list;
    private String valueMethodName;

    public ListSpinner(Component c, List<LT> list, String componentSetValueMethodName) {
        this(c, list, componentSetValueMethodName, 0);
    }

    public ListSpinner(Component c, List<LT> list, String componentSetValueMethodName, int startingIndex) {
        super(c);
        this.setList(list);
        this.setValueMethodName(componentSetValueMethodName);
        this.setCurrentIndex(startingIndex);
        this.addSpinListener(this);
    }

    public List<LT> getList() {
        return this.list;
    }

    public void setList(List<LT> list) {
        this.list = list;
    }

    public String getValueMethodName() {
        return this.valueMethodName;
    }

    public void setValueMethodName(String setValueMethodName) {
        this.valueMethodName = setValueMethodName;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        int listSize = this.list.size() - 1;
        this.currentIndex = currentIndex > listSize ? 0 : (currentIndex < 0 ? listSize : currentIndex);
        this.newValue = this.list.get(this.currentIndex);
        if (this.oldValue == null || !this.oldValue.equals(this.newValue)) {
            BeanService.setPropertyValue(this.component, this.valueMethodName, this.newValue);
        }
        this.oldValue = this.newValue;
    }

    @Override
    public void spinDown(SpinEvent e) {
        this.setCurrentIndex(this.currentIndex + 1);
    }

    @Override
    public void spinUp(SpinEvent e) {
        this.setCurrentIndex(this.currentIndex - 1);
    }
}

