/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.splitpane;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JPanel;
import javax.swing.UIManager;

class SplitPaneDivider
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int ORIENTATION_VERTICAL = 0;
    public static final int ORIENTATION_HORIZONTAL = 1;
    private int order;
    private int orientation;
    private Point dragLocationOffset;

    public SplitPaneDivider(int order, int orientation) {
        this.setOpaque(true);
        this.setBackground(UIManager.getColor("SplitPane.background"));
        this.setBorder(UIManager.getBorder("SplitPaneDivider.border"));
        this.setOrder(order);
        this.setOrientation(orientation);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 0: {
                this.orientation = orientation;
                this.setCursor(new Cursor(11));
                break;
            }
            case 1: {
                this.orientation = orientation;
                this.setCursor(new Cursor(8));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The given orientation %d is not valid.  It should be one of SplitPaneDivider.ORIENTATION_VERTICAL or SplitPaneDivider.ORIENTATION_HORIZONTAL", orientation));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point mouseLocation = e.getPoint();
        Point sliderLocation = this.getLocation();
        int x = 0;
        int y = 0;
        switch (this.orientation) {
            case 0: {
                x = sliderLocation.x + mouseLocation.x - this.dragLocationOffset.x;
                y = sliderLocation.y;
                break;
            }
            case 1: {
                x = sliderLocation.x;
                y = sliderLocation.y + mouseLocation.y - this.dragLocationOffset.y;
            }
        }
        this.setLocation(x, y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragLocationOffset = e.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void setLocation(int x, int y) {
        PropertyChangeEvent pceX = new PropertyChangeEvent(this, "x", this.getX(), x);
        PropertyChangeEvent pceY = new PropertyChangeEvent(this, "y", this.getY(), y);
        try {
            VetoableChangeListener[] vetoableChangeListenerArray = this.getVetoableChangeListeners();
            int n = vetoableChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                VetoableChangeListener listener = vetoableChangeListenerArray[n2];
                listener.vetoableChange(pceX);
                listener.vetoableChange(pceY);
                ++n2;
            }
        }
        catch (PropertyVetoException veto) {
            return;
        }
        super.setLocation(x, y);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Dimension size = this.getSize();
        Color speckleColor = UIManager.getColor("SplitPaneDivider.speckleColor");
        g2.setColor(speckleColor);
        int y = 2;
        int r = 2;
        while (y < size.height - 1) {
            int x = r % 2 == 0 ? 2 : 3;
            while (x < size.width - 1) {
                g2.fillRect(x, y, 1, 1);
                x += 2;
            }
            y += 2;
            ++r;
        }
    }
}

