/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.tabbedpane;

import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.tabbedpane.AlwaysAcceptTabAcceptor;
import com.jmorgan.swing.tabbedpane.GhostGlassPane;
import com.jmorgan.swing.tabbedpane.JMDragGestureListener;
import com.jmorgan.swing.tabbedpane.JMDragSourceListener;
import com.jmorgan.swing.tabbedpane.JMDropTargetListener;
import com.jmorgan.swing.tabbedpane.TabAcceptor;
import com.jmorgan.swing.tabbedpane.TabTransferData;
import com.jmorgan.swing.tabbedpane.TabbedPaneDNDConstants;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;

public class TabPlacementDNDController {
    private JMTabbedPane tabbedPane;
    private GhostGlassPane tabTransferGlassPane;
    private final JMDragSourceListener dragSourceListener;
    private final JMDragGestureListener dragGestureListener;
    private boolean shouldDrawRect;
    private boolean hasGhost = true;
    private final Rectangle2D lineRectangle = new Rectangle2D.Double();
    private TabAcceptor tabAcceptor;

    public TabPlacementDNDController(JMTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
        this.tabTransferGlassPane = new GhostGlassPane();
        new DropTarget(this.tabbedPane, 3, new JMDropTargetListener(this), true);
        this.dragSourceListener = new JMDragSourceListener(this);
        this.dragGestureListener = new JMDragGestureListener(this, this.dragSourceListener);
        new DragSource().createDefaultDragGestureRecognizer(this.tabbedPane, 3, this.dragGestureListener);
        this.tabAcceptor = new AlwaysAcceptTabAcceptor();
        tabbedPane.setTabPlacementDNDController(this);
    }

    public JMTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public boolean shouldDrawRect() {
        return this.shouldDrawRect;
    }

    void setShouldDrawRect(boolean shouldDrawRect) {
        this.shouldDrawRect = shouldDrawRect;
    }

    public Rectangle2D getLineRectangle() {
        return this.lineRectangle;
    }

    public void setPaintGhost(boolean shouldBePainted) {
        this.hasGhost = shouldBePainted;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    public TabAcceptor getAcceptor() {
        return this.tabAcceptor;
    }

    public void setAcceptor(TabAcceptor tabAcceptor) {
        this.tabAcceptor = tabAcceptor;
    }

    TabTransferData getTabTransferData(DropTargetDropEvent dropEvent) {
        try {
            TabTransferData data = (TabTransferData)dropEvent.getTransferable().getTransferData(TabbedPaneDNDConstants.TAB_TRANSFER_DATA_FLAVOR);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    TabTransferData getTabTransferData(DropTargetDragEvent dragEvent) {
        try {
            TabTransferData data = (TabTransferData)dragEvent.getTransferable().getTransferData(TabbedPaneDNDConstants.TAB_TRANSFER_DATA_FLAVOR);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    TabTransferData getTabTransferData(DragSourceDragEvent dragSourceEvent) {
        try {
            TabTransferData data = (TabTransferData)dragSourceEvent.getDragSourceContext().getTransferable().getTransferData(TabbedPaneDNDConstants.TAB_TRANSFER_DATA_FLAVOR);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    void updateGlassPane(DropTargetDragEvent dragEvent) {
        TabTransferData data = this.getTabTransferData(dragEvent);
        int tabPlacement = this.tabbedPane.getTabPlacement();
        Point dragLocation = dragEvent.getLocation();
        if (tabPlacement == 1 || tabPlacement == 3) {
            this.initTargetLeftRightLine(dragLocation, data);
        } else {
            this.initTargetTopBottomLine(dragLocation, data);
        }
        this.tabbedPane.repaint();
        if (this.hasGhost()) {
            Point ghostLocation = this.buildGhostLocation(dragLocation);
            this.tabTransferGlassPane.setPoint(ghostLocation);
            this.tabTransferGlassPane.repaint();
        }
    }

    private Point buildGhostLocation(Point location) {
        Point ghostLocation = new Point(location);
        Insets insets = this.tabbedPane.getInsets();
        switch (this.tabbedPane.getTabPlacement()) {
            case 1: {
                ghostLocation.y = 1 + insets.top;
                ghostLocation.x -= this.tabTransferGlassPane.getGhostWidth() / 2;
                break;
            }
            case 3: {
                ghostLocation.y = this.tabbedPane.getHeight() - 1 - insets.bottom - this.tabTransferGlassPane.getGhostHeight();
                ghostLocation.x -= this.tabTransferGlassPane.getGhostWidth() / 2;
                break;
            }
            case 2: {
                ghostLocation.x = 1 + insets.left;
                ghostLocation.y -= this.tabTransferGlassPane.getGhostHeight() / 2;
                break;
            }
            case 4: {
                ghostLocation.x = this.tabbedPane.getWidth() - 1 - insets.right - this.tabTransferGlassPane.getGhostWidth();
                ghostLocation.y -= this.tabTransferGlassPane.getGhostHeight() / 2;
            }
        }
        ghostLocation = SwingUtilities.convertPoint(this.tabbedPane, ghostLocation, this.tabTransferGlassPane);
        return ghostLocation;
    }

    int getTargetTabIndex(Point location) {
        int tabPlacement = this.tabbedPane.getTabPlacement();
        boolean isTopOrBottom = tabPlacement == 1 || tabPlacement == 3;
        int tabCount = this.tabbedPane.getTabCount();
        if (tabCount == 0) {
            return 0;
        }
        int i = 0;
        while (i < tabCount) {
            Rectangle r = this.tabbedPane.getBoundsAt(i);
            if (isTopOrBottom) {
                r.setRect(r.x - r.width / 2, r.y, r.width, r.height);
            } else {
                r.setRect(r.x, r.y - r.height / 2, r.width, r.height);
            }
            if (r.contains(location)) {
                return i;
            }
            ++i;
        }
        Rectangle r = this.tabbedPane.getBoundsAt(tabCount - 1);
        if (isTopOrBottom) {
            int x = r.x + r.width / 2;
            r.setRect(x, r.y, this.tabbedPane.getWidth() - x, r.height);
        } else {
            int y = r.y + r.height / 2;
            r.setRect(r.x, y, r.width, this.tabbedPane.getHeight() - y);
        }
        return r.contains(location) ? tabCount : -1;
    }

    void convertTab(TabTransferData tabTransferData, int targetIndex) {
        JMTabbedPane source = tabTransferData.getTabbedPane();
        int sourceIndex = tabTransferData.getTabIndex();
        if (sourceIndex < 0) {
            return;
        }
        Component component = source.getComponentAt(sourceIndex);
        String tabTitle = source.getTitleAt(sourceIndex);
        Component tabComponent = source.getTabComponentAt(sourceIndex);
        int tabCount = this.tabbedPane.getTabCount();
        if (this.tabbedPane != source) {
            source.remove(sourceIndex);
            if (targetIndex == tabCount) {
                this.tabbedPane.addTab(tabTitle, component);
                this.tabbedPane.setTabComponentAt(tabCount - 1, tabComponent);
            } else {
                if (targetIndex < 0) {
                    targetIndex = 0;
                }
                this.tabbedPane.insertTab(tabTitle, null, component, null, targetIndex);
                this.tabbedPane.setTabComponentAt(targetIndex, tabComponent);
            }
            this.tabbedPane.setSelectedComponent(component);
            return;
        }
        if (targetIndex < 0 || sourceIndex == targetIndex) {
            return;
        }
        if (targetIndex == tabCount) {
            source.remove(sourceIndex);
            this.tabbedPane.addTab(tabTitle, component);
            this.tabbedPane.setTabComponentAt(tabCount - 1, tabComponent);
            this.tabbedPane.setSelectedIndex(tabCount - 1);
        } else if (sourceIndex > targetIndex) {
            source.remove(sourceIndex);
            this.tabbedPane.insertTab(tabTitle, null, component, null, targetIndex);
            this.tabbedPane.setTabComponentAt(targetIndex, tabComponent);
            this.tabbedPane.setSelectedIndex(targetIndex);
        } else {
            source.remove(sourceIndex);
            this.tabbedPane.insertTab(tabTitle, null, component, null, targetIndex - 1);
            this.tabbedPane.setTabComponentAt(targetIndex - 1, tabComponent);
            this.tabbedPane.setSelectedIndex(targetIndex - 1);
        }
    }

    void initTargetLeftRightLine(Point tabLocation, TabTransferData tabTransferData) {
        int next = this.getTargetTabIndex(tabLocation);
        if (next < 0) {
            this.resetRect();
            return;
        }
        int tabCount = this.tabbedPane.getTabCount();
        int tabIndex = tabTransferData.getTabIndex();
        if (tabTransferData.getTabbedPane() == this.tabbedPane && (tabIndex == next || next - tabIndex == 1)) {
            this.resetRect();
        } else {
            if (tabCount == 0) {
                this.resetRect();
                return;
            }
            if (next == 0) {
                Rectangle rect = this.tabbedPane.getBoundsAt(0);
                this.lineRectangle.setRect(-TabbedPaneDNDConstants.HALF_LINE_WIDTH, rect.y, TabbedPaneDNDConstants.LINEWIDTH, rect.height);
                this.shouldDrawRect = true;
            } else if (next == tabCount) {
                Rectangle rect = this.tabbedPane.getBoundsAt(tabCount - 1);
                this.lineRectangle.setRect(rect.x + rect.width - TabbedPaneDNDConstants.HALF_LINE_WIDTH, rect.y, TabbedPaneDNDConstants.LINEWIDTH, rect.height);
                this.shouldDrawRect = true;
            } else {
                Rectangle rect = this.tabbedPane.getBoundsAt(next - 1);
                this.lineRectangle.setRect(rect.x + rect.width - TabbedPaneDNDConstants.HALF_LINE_WIDTH, rect.y, TabbedPaneDNDConstants.LINEWIDTH, rect.height);
                this.shouldDrawRect = true;
            }
        }
    }

    void initTargetTopBottomLine(Point tabLocation, TabTransferData tabTransferData) {
        int next = this.getTargetTabIndex(tabLocation);
        if (next < 0 || this.tabbedPane == null || tabTransferData == null) {
            this.resetRect();
            return;
        }
        int tabCount = this.tabbedPane.getTabCount();
        int tabIndex = tabTransferData.getTabIndex();
        if (tabTransferData.getTabbedPane() == this.tabbedPane && (tabIndex == next || next - tabIndex == 1)) {
            this.resetRect();
        } else {
            if (tabCount == 0) {
                this.resetRect();
                return;
            }
            if (next == 0) {
                Rectangle rect = this.tabbedPane.getBoundsAt(0);
                this.lineRectangle.setRect(rect.x, -TabbedPaneDNDConstants.HALF_LINE_WIDTH, rect.width, TabbedPaneDNDConstants.LINEWIDTH);
                this.shouldDrawRect = true;
            } else if (next == tabCount) {
                Rectangle rect = this.tabbedPane.getBoundsAt(tabCount - 1);
                this.lineRectangle.setRect(rect.x, rect.y + rect.height - TabbedPaneDNDConstants.HALF_LINE_WIDTH, rect.width, TabbedPaneDNDConstants.LINEWIDTH);
                this.shouldDrawRect = true;
            } else {
                Rectangle rect = this.tabbedPane.getBoundsAt(next - 1);
                this.lineRectangle.setRect(rect.x, rect.y + rect.height - TabbedPaneDNDConstants.HALF_LINE_WIDTH, rect.width, TabbedPaneDNDConstants.LINEWIDTH);
                this.shouldDrawRect = true;
            }
        }
    }

    void resetRect() {
        this.lineRectangle.setRect(0.0, 0.0, 0.0, 0.0);
        this.shouldDrawRect = false;
    }

    void initGlassPane(Component c, Point tabLocation, int tabIndex) {
        this.tabbedPane.getRootPane().setGlassPane(this.tabTransferGlassPane);
        if (this.hasGhost()) {
            Rectangle rect = this.tabbedPane.getBoundsAt(tabIndex);
            BufferedImage image = new BufferedImage(this.tabbedPane.getWidth(), this.tabbedPane.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            this.tabTransferGlassPane.setImage(image);
        }
        this.tabTransferGlassPane.setPoint(this.buildGhostLocation(tabLocation));
        this.tabTransferGlassPane.setVisible(true);
    }

    void stopDragging() {
        this.resetRect();
        this.tabTransferGlassPane.setPoint(TabbedPaneDNDConstants.OFFSCREEN_POINT);
        this.tabTransferGlassPane.repaint();
    }

    void hideGlassPane() {
        this.tabTransferGlassPane.setVisible(false);
        this.tabTransferGlassPane.setImage(null);
    }
}

