/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.table;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMComboBoxEditor;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.event.KeyEventInvoker;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public abstract class ComboBoxTableCellEditor
extends DefaultCellEditor
implements TableCellRenderer,
TableModelListener {
    private DefaultComboBoxModel<String> cbxModel;
    private JMComboBox<String> editor = (JMComboBox)this.getComponent();
    private JMTextField renderer;
    private ArrayList<String> comboBoxElements;
    private KeyEventInvoker keyEventInvoker;

    public ComboBoxTableCellEditor() {
        super(new JMComboBox(new DefaultComboBoxModel()));
        this.cbxModel = (DefaultComboBoxModel)this.editor.getModel();
        this.renderer = new JMTextField();
    }

    public void makeComboBoxEditable() {
        this.editor.setEditable(true);
        this.editor.setEditor(new JMComboBoxEditor());
        JTextComponent textComponent = (JTextComponent)this.editor.getEditor().getEditorComponent();
        this.keyEventInvoker = new KeyEventInvoker((Object)textComponent, 4, this, "handleKeyEvent");
    }

    @Reflected
    private void handleKeyEvent() {
        KeyEvent keyEvent = (KeyEvent)this.keyEventInvoker.getEvent();
        char keyChar = keyEvent.getKeyChar();
        if (keyChar == '\n' || keyChar == '\t') {
            JComponent editingSource = (JComponent)keyEvent.getSource();
            JComboBox editingComboBox = (JComboBox)editingSource.getParent();
            JTable containingTable = (JTable)editingComboBox.getParent();
            TableCellEditor editor = containingTable.getCellEditor();
            if (editor != null) {
                editor.stopCellEditing();
            }
            int editedRow = containingTable.getEditingRow();
            int editedColumn = containingTable.getEditingColumn();
            int rowCount = containingTable.getRowCount();
            int columnCount = containingTable.getColumnCount();
            int nextEditableRow = -1;
            int nextEditableColumn = -1;
            int row = editedRow;
            block0: while (row < rowCount) {
                int col = row == editedRow ? editedColumn : 0;
                while (col < columnCount) {
                    if (containingTable.isCellEditable(row, col)) {
                        nextEditableRow = row;
                        nextEditableColumn = col;
                        break block0;
                    }
                    ++col;
                }
                ++row;
            }
            if (nextEditableRow >= 0 && nextEditableColumn >= 0) {
                containingTable.changeSelection(nextEditableRow, nextEditableColumn, false, false);
            }
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editor.setSelectedItem(value);
        return this.getComponent();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String editorValue = (String)this.editor.getEditor().getItem();
        if (StringUtility.isNotEmpty(editorValue)) {
            boolean exists = false;
            int z = this.cbxModel.getSize();
            int i = 0;
            while (i < z) {
                String v = this.cbxModel.getElementAt(i);
                if (v.equals(editorValue)) {
                    exists = true;
                    break;
                }
                ++i;
            }
            if (!exists) {
                this.cbxModel.addElement(editorValue);
                this.editor.setSelectedItem(editorValue);
                table.setValueAt(editorValue, row, column);
            }
        }
        if (value == null) {
            value = "";
        }
        this.renderer.setText(String.valueOf(value));
        return this.renderer;
    }

    public void setComboBoxElements(ArrayList<String> comboBoxElements) {
        this.comboBoxElements = comboBoxElements;
        this.updateComboBoxModel();
    }

    public void setComboBoxElements(String[] comboBoxElements) {
        this.comboBoxElements = new ArrayList(comboBoxElements.length);
        CollectionUtility.addAll(comboBoxElements, this.comboBoxElements);
        this.updateComboBoxModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComboBoxModel() {
        if (this.comboBoxElements == null) {
            return;
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = this.cbxModel;
        synchronized (defaultComboBoxModel) {
            this.cbxModel.removeAllElements();
            this.renderer.setText("");
            for (String comboBoxElement : this.comboBoxElements) {
                this.cbxModel.addElement(comboBoxElement);
            }
            if (CollectionUtility.isNotEmpty(this.comboBoxElements)) {
                this.cbxModel.setSelectedItem(this.comboBoxElements.get(0));
            }
        }
    }
}

