/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.text.editor.actions.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HTMLPreviewFrame
extends JFrame
implements DocumentListener {
    Document doc;
    private JEditorPane jEdtHtml;
    private JScrollPane jScrollPane1;

    public HTMLPreviewFrame(Document doc) {
        this.initComponents();
        this.doc = doc;
        doc.addDocumentListener(this);
        this.updateHTML();
    }

    private void updateHTML() {
        try {
            this.jEdtHtml.setText(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException ex) {
            Logger.getLogger(HTMLPreviewFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jEdtHtml = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("HTML Preview");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                HTMLPreviewFrame.this.onWindowClosed(evt);
            }
        });
        this.jEdtHtml.setContentType("text/html");
        this.jEdtHtml.setEditable(false);
        this.jScrollPane1.setViewportView(this.jEdtHtml);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 688, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 449, Short.MAX_VALUE));
        this.pack();
    }

    private void onWindowClosed(WindowEvent evt) {
        this.doc.removeDocumentListener(this);
        this.doc.putProperty("html-preview-window", null);
        this.doc = null;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateHTML();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateHTML();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateHTML();
    }
}

