/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.swing.style.BorderStyle;
import com.jmorgan.swing.style.ColorStyle;
import com.jmorgan.swing.style.TextStyle;
import com.jmorgan.swing.util.ComponentConstants;
import com.jmorgan.swing.util.HoverController;
import java.awt.Component;
import javax.swing.JComponent;

public class HoverStyleController
extends HoverController {
    private TextStyle oldStyle;
    private TextStyle hoverStyle;

    public HoverStyleController() {
        ColorStyle highStyle = new ColorStyle(ComponentConstants.backgroundColor, ComponentConstants.textColor);
        BorderStyle borderStyle = new BorderStyle(ComponentConstants.controlBorder);
        this.hoverStyle = new TextStyle(highStyle, borderStyle, ComponentConstants.textFont);
        this.oldStyle = new TextStyle(highStyle, borderStyle, ComponentConstants.textFont);
    }

    public HoverStyleController(TextStyle textStyle) {
        this();
        this.setTextStyle(textStyle);
    }

    public TextStyle getOldStyle() {
        return this.oldStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (textStyle == null) {
            return;
        }
        this.hoverStyle = textStyle;
    }

    @Override
    public void addComponent(Component c) {
        super.addComponent(c);
        if (c instanceof JComponent) {
            ((JComponent)c).setOpaque(true);
        }
    }

    @Override
    public void mouseEntered(Component component) {
        this.oldStyle.setFont(component.getFont());
        this.oldStyle.getColor().setBackground(component.getBackground());
        this.oldStyle.getColor().setForeground(component.getForeground());
        if (component instanceof JComponent) {
            this.oldStyle.setBorder(new BorderStyle(((JComponent)component).getBorder()));
        }
        ColorStyle hoverColorStyle = this.hoverStyle.getColor();
        component.setBackground(hoverColorStyle.getBackground());
        component.setForeground(hoverColorStyle.getForeground());
        component.setFont(this.hoverStyle.getFont());
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(this.hoverStyle.getBorder().getBorder());
        }
    }

    @Override
    public void mouseExited(Component component) {
        ColorStyle oldColorStyle = this.oldStyle.getColor();
        component.setBackground(oldColorStyle.getBackground());
        component.setForeground(oldColorStyle.getForeground());
        component.setFont(this.oldStyle.getFont());
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(this.oldStyle.getBorder().getBorder());
        }
    }
}

