/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.component.MirrorComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.menu.JMMenu;
import com.jmorgan.swing.menu.JMMenuItem;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.TabbedPaneMenuActions;
import com.jmorgan.swing.util.VisualComponentEditor;
import com.jmorgan.swing.util.VisualComponentEditorProperties;
import com.jmorgan.util.Pair;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

class VisualComponentEditorPopup
extends JPopupMenu {
    private JComponent component;
    private JMMenuItem copy;
    private JMMenuItem mirror;
    private JMMenuItem moveToTop;
    private JMMenuItem moveUp;
    private JMMenuItem moveDown;
    private JMMenuItem moveToBottom;
    private JMMenuItem saveAs;
    private JMMenuItem delete;
    private JMMenuItem addTab;
    private JMMenuItem removeTab;
    private JMMenuItem properties;

    public VisualComponentEditorPopup(JComponent component) {
        this.component = component;
        this.copy = this.createMenuItem("Copy", this, "copy", this);
        this.mirror = this.createMenuItem("Create Mirror", this, "mirror", this);
        this.addSeparator();
        this.saveAs = this.createMenuItem("Save As...", this, "saveAs", this);
        this.delete = this.createMenuItem("Delete", this, "delete", this);
        this.addSeparator();
        JMMenu orderMenu = new JMMenu("Order");
        this.moveToTop = this.createMenuItem("Move to Front", this, "moveToTop", orderMenu);
        this.moveUp = this.createMenuItem("Forward", this, "moveUp", orderMenu);
        this.moveDown = this.createMenuItem("Backward", this, "moveDown", orderMenu);
        this.moveToBottom = this.createMenuItem("Move to Back", this, "moveToBottom", orderMenu);
        this.add(orderMenu);
        if (component instanceof JTabbedPane) {
            this.addSeparator();
            TabbedPaneMenuActions menuActions = new TabbedPaneMenuActions((JMTabbedPane)component);
            this.addTab = this.createMenuItem("Add Tab", menuActions, "addTab", this);
            this.removeTab = this.createMenuItem("Remove Tab", menuActions, "removeTab", this);
        }
        this.addSeparator();
        this.properties = this.createMenuItem("&Properties...", this, "properties", this);
    }

    private JMMenuItem createMenuItem(String text, Object invocationTarget, String methodToInvoke, Object parentMenu) {
        JMMenuItem item = new JMMenuItem(text);
        new ActionEventInvoker(item, invocationTarget, methodToInvoke);
        if (parentMenu instanceof JPopupMenu) {
            ((JPopupMenu)parentMenu).add(item);
        } else if (parentMenu instanceof JMenu) {
            ((JMenu)parentMenu).add(item);
        }
        return item;
    }

    public void setMenuState() {
        Container parent = this.component.getParent();
        if (parent instanceof JTabbedPane) {
            JTabbedPane tp = (JTabbedPane)parent;
            int tabCount = tp.getTabCount();
            this.removeTab.setEnabled(tabCount > 0);
        }
        if (parent instanceof JLayeredPane) {
            JLayeredPane cfr_ignored_0 = (JLayeredPane)parent;
            int layer = JLayeredPane.getLayer(this.component);
            int lowestLayer = ((JLayeredPane)parent).lowestLayer();
            int highestLayer = ((JLayeredPane)parent).highestLayer();
            this.moveToTop.setEnabled(layer < highestLayer);
            this.moveUp.setEnabled(layer < highestLayer);
            this.moveToBottom.setEnabled(layer > lowestLayer);
            this.moveDown.setEnabled(layer > lowestLayer);
            return;
        }
        int zOrder = parent.getComponentZOrder(this.component);
        this.moveToTop.setEnabled(zOrder == 0);
        this.moveUp.setEnabled(zOrder == 0);
        int cc = this.component.getParent().getComponentCount() - 1;
        this.moveToBottom.setEnabled(zOrder == cc);
        this.moveDown.setEnabled(zOrder == cc);
    }

    @Reflected
    public void copy() {
    }

    @Reflected
    public void mirror() {
        MirrorComponent mirroredComponent = new MirrorComponent(this.component);
        Rectangle sourceBounds = this.component.getBounds();
        Rectangle mirrorBounds = new Rectangle(sourceBounds);
        mirrorBounds.y += sourceBounds.height + 5;
        mirroredComponent.setBounds(mirrorBounds);
        Container parent = this.component.getParent();
        parent.add(mirroredComponent);
        new VisualComponentEditor(mirroredComponent);
    }

    @Reflected
    public void saveAs() {
        ArrayList components = (ArrayList)GUIServices.getAllComponents(GUIServices.getFrame(this.component));
        Collections.reverse(components);
        for (Component comp : components) {
            if (!comp.isVisible() || !comp.isShowing()) continue;
            try {
                MethodInvoker methodInvoker = new MethodInvoker((Object)comp, "visualEditorSaveAs", this.component);
                methodInvoker.invoke();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void moveToTop() {
        Container parent = this.component.getParent();
        if (parent instanceof JLayeredPane) {
            int topLayer = ((JLayeredPane)parent).highestLayer();
            ((JLayeredPane)parent).setLayer(this.component, topLayer + 10);
            return;
        }
        System.out.println("VisualComponentEditorPopup.moveToTop(): Not on a JLayeredPane");
    }

    public void moveToBottom() {
        Container parent = this.component.getParent();
        if (parent instanceof JLayeredPane) {
            int bottomLayer = ((JLayeredPane)parent).lowestLayer();
            ((JLayeredPane)parent).setLayer(this.component, bottomLayer - 10);
            return;
        }
        System.out.println("VisualComponentEditorPopup.moveToBottom(): Not on a JLayeredPane");
    }

    public void moveUp() {
        Container parent = this.component.getParent();
        if (parent instanceof JLayeredPane) {
            JLayeredPane pane = (JLayeredPane)parent;
            int thisLayer = JLayeredPane.getLayer(this.component);
            ArrayList<Pair<Integer, Component>> layers = this.getComponentLayers();
            for (Pair<Integer, Component> layer : layers) {
                if (thisLayer >= (Integer)layer.first) continue;
                pane.setLayer(this.component, (Integer)layer.first);
                pane.setLayer((Component)layer.second, thisLayer);
                break;
            }
            return;
        }
        System.out.println("VisualComponentEditorPopup.moveUp(): Not a JLayeredPane");
        int zOrder = parent.getComponentZOrder(this.component);
        if (zOrder == 0) {
            return;
        }
        parent.setComponentZOrder(this.component, zOrder - 1);
    }

    public void moveDown() {
        Container parent = this.component.getParent();
        if (parent instanceof JLayeredPane) {
            JLayeredPane pane = (JLayeredPane)parent;
            int thisLayer = JLayeredPane.getLayer(this.component);
            ArrayList<Pair<Integer, Component>> layers = this.getComponentLayers();
            Pair<Integer, Component> previousLayer = layers.get(0);
            for (Pair<Integer, Component> layer : layers) {
                if (thisLayer != (Integer)layer.first) {
                    previousLayer = layer;
                    continue;
                }
                pane.setLayer(this.component, (Integer)previousLayer.first);
                pane.setLayer((Component)previousLayer.second, thisLayer);
                break;
            }
            return;
        }
        System.err.println("VisualComponentEditorPopup.moveDown() Not a JLayeredPane");
        int zOrder = parent.getComponentZOrder(this.component);
        if (zOrder == parent.getComponentCount() - 1) {
            return;
        }
        parent.setComponentZOrder(this.component, zOrder + 1);
    }

    private ArrayList<Pair<Integer, Component>> getComponentLayers() {
        Container parent = this.component.getParent();
        Component[] comps = parent.getComponents();
        ArrayList<Pair<Integer, Component>> layers = new ArrayList<Pair<Integer, Component>>();
        if (parent instanceof JLayeredPane) {
            JLayeredPane pane = (JLayeredPane)parent;
            Component[] componentArray = comps;
            int n = comps.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                int layer = pane.getLayer(comp);
                layers.add(new Pair<Integer, Component>(layer, comp));
                ++n2;
            }
            Collections.sort(layers);
            return layers;
        }
        Component[] componentArray = comps;
        int n = comps.length;
        int n3 = 0;
        while (n3 < n) {
            Component comp = componentArray[n3];
            int zOrder = parent.getComponentZOrder(comp);
            layers.add(new Pair<Integer, Component>(zOrder, comp));
            ++n3;
        }
        Collections.sort(layers);
        Collections.reverse(layers);
        return layers;
    }

    @Reflected
    public void delete() {
        new JMMessageBox(null, "Delete Component", "Are you sure you want to delete this component?", 12);
        if (JMMessageBox.getSelection() == 4) {
            Container parent = this.component.getParent();
            parent.remove(this.component);
            this.component = null;
            parent.repaint();
        }
    }

    @Reflected
    public void properties() {
        VisualComponentEditorProperties propertiesDialog = new VisualComponentEditorProperties(GUIServices.getFrame(this.component), this.component);
        propertiesDialog.dispose();
    }
}

