/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.swing.util;

import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMFrame;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.collection.CollectionUtility;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WindowCloser
extends WindowAdapter {
    public static final int SIMPLE_CLOSE_OPERATION = 0;
    public static final int EXIT_APPLICATION_ON_CLOSE = 1;
    public static final int DO_NOTHING_ON_CLOSE = 2;
    private Window window;
    private int closeOption = 0;
    private boolean queryClose = true;
    private Index<Integer, MethodInvoker<?>> notificationTargets;

    public WindowCloser(Window w) {
        this.window = w;
        if (w instanceof JFrame) {
            ((JFrame)w).setDefaultCloseOperation(0);
        }
        if (w instanceof JDialog) {
            ((JDialog)w).setDefaultCloseOperation(0);
        }
        this.window.addWindowListener(this);
    }

    public WindowCloser(Window w, int closeOption) {
        this(w);
        this.closeOption = closeOption;
    }

    public WindowCloser(Window w, int closeOption, boolean queryClose) {
        this(w, closeOption);
        this.queryClose = queryClose;
    }

    public void addNotificationTarget(int action, Object target, String methodName, Object ... arguments) throws IllegalArgumentException {
        MethodInvoker methodPointer;
        String exceptionPrefix = String.format("WindowCloser.addNotificationTarget(action=%d, target=%s, methodName=%s):", action, target == null ? "null" : target.getClass().getName(), methodName == null ? "null" : methodName);
        switch (action) {
            case 201: 
            case 202: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("%s The value for 'action' is not valid", exceptionPrefix, action));
            }
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("%s 'target' cannot be null", exceptionPrefix), new NullPointerException());
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("%s 'methodName' cannot be null", exceptionPrefix), new NullPointerException());
        }
        MethodInvoker methodInvoker = methodPointer = ArrayUtility.isEmpty(arguments) ? new MethodInvoker(target, methodName, new Object[0]) : new MethodInvoker(target, methodName, arguments);
        if (this.notificationTargets == null) {
            this.notificationTargets = new Index();
        }
        this.notificationTargets.put((Integer)action, methodPointer);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.notifyNotificationTargets(201);
        WindowCloser.closeWindow(this.window, this.closeOption, this.queryClose);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.notifyNotificationTargets(202);
    }

    private boolean notifyNotificationTargets(int windowEventCode) {
        Collection<MethodInvoker<?>> notificationSet;
        if (this.notificationTargets != null && CollectionUtility.isNotEmpty(notificationSet = this.notificationTargets.get(windowEventCode))) {
            for (MethodInvoker<?> methodPointer : notificationSet) {
                Boolean responseValue;
                Object response = methodPointer.invoke();
                if (windowEventCode != 201 || response == null || !(response instanceof Boolean) || (responseValue = (Boolean)response).booleanValue()) continue;
                return responseValue;
            }
        }
        return true;
    }

    public void closeWindow() {
        this.windowClosing(null);
        WindowCloser.closeWindow(this.window);
        this.windowClosed(null);
    }

    public static void closeWindow(Window window) {
        WindowCloser.closeWindow(window, 0, false);
    }

    public static void closeWindow(Window w, int closeOption) {
        WindowCloser.closeWindow(w, closeOption, true);
    }

    public static boolean closeWindow(Window w, int closeOption, boolean queryClose) {
        String title = "this";
        if (queryClose && (w instanceof JFrame || w instanceof JDialog)) {
            JMFrame bf;
            if (w instanceof JFrame) {
                title = ((JFrame)w).getTitle();
            }
            if (w instanceof JDialog) {
                title = ((JDialog)w).getTitle();
            }
            if (w instanceof JMFrame && !(bf = (JMFrame)w).canExit()) {
                return false;
            }
            int result = JOptionPane.showConfirmDialog(w, "Close " + title + " Now?", "Close " + title + "?", 0);
            if (result == 1) {
                return false;
            }
            if (w instanceof JMFrame) {
                JMFrame jmFrame = (JMFrame)w;
                WindowCloser instance = jmFrame.getWindowCloser();
                instance.notifyNotificationTargets(201);
            } else if (w instanceof JMDialog) {
                JMDialog jmDialog = (JMDialog)w;
                WindowCloser instance = jmDialog.getWindowCloser();
                instance.notifyNotificationTargets(201);
            }
        }
        WindowCloser.commitClose(w, closeOption);
        return true;
    }

    private static void commitClose(Window window, int closeOption) {
        if (closeOption == 2) {
            return;
        }
        window.setVisible(false);
        if (closeOption == 0 || !(window instanceof JDialog) && !(window instanceof Dialog)) {
            if (window instanceof JMFrame) {
                JMFrame jmFrame = (JMFrame)window;
                WindowCloser instance = jmFrame.getWindowCloser();
                instance.notifyNotificationTargets(202);
            } else if (window instanceof JMDialog) {
                JMDialog jmDialog = (JMDialog)window;
                WindowCloser instance = jmDialog.getWindowCloser();
                instance.notifyNotificationTargets(202);
            }
            window.dispose();
        }
        if (closeOption == 1) {
            System.exit(0);
        }
    }
}

