/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

public final class BaseConverter {
    public static final char baseSymbol = '7';

    private BaseConverter() {
    }

    public static String convertToBase(String dv, long fromBase, long toBase) {
        double d = BaseConverter.convertBaseXToBase10(dv, fromBase);
        return BaseConverter.convertBase10ToBaseX(d, toBase);
    }

    public static double convertBaseXToBase10(String dv, long fromBase) {
        if (fromBase == 10L) {
            return Double.parseDouble(dv);
        }
        boolean negative = false;
        double d = 0.0;
        int dvl = dv.length();
        int i = 0;
        while (i < dvl) {
            char c = dv.charAt(i);
            if (c == '-') {
                negative = true;
            } else {
                c = (char)(c - (c >= 'A' ? 55 : 48));
                d += (double)c * Math.pow(fromBase, dvl - (i + 1));
            }
            ++i;
        }
        if (negative) {
            d *= -1.0;
        }
        return d;
    }

    public static String convertBase10ToBaseX(double v, long toBase) {
        if (toBase == 10L) {
            return "" + v;
        }
        StringBuilder cValue = new StringBuilder("");
        boolean negative = false;
        if (v < 0.0) {
            v *= -1.0;
            negative = true;
        }
        while (v > (double)(toBase - 1L)) {
            char c = '0';
            int r = (int)((long)v % toBase);
            c = r > 9 && toBase > 10L ? (char)(r + 55) : (char)((char)(r + 48));
            cValue.append(c);
            v = (long)(v / (double)toBase);
        }
        if (v > 9.0 && toBase > 10L) {
            cValue.append((char)(v + 55.0));
        } else {
            cValue.append("" + (long)v);
        }
        if (negative) {
            cValue.append('-');
        }
        char[] chs = cValue.toString().toCharArray();
        char[] newChs = new char[chs.length];
        int i = 0;
        while (i < chs.length) {
            newChs[chs.length - (i + 1)] = chs[i];
            ++i;
        }
        String value = new String(newChs);
        return value;
    }
}

