/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateException;
import com.jmorgan.util.DateMetaData;
import com.jmorgan.util.DateTimeException;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringIndexer;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.TimeMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateTime
extends JMBean
implements Comparable<DateTime> {
    private Date date;
    private Time time;
    private SimpleDateFormat formatter;

    public static final boolean isDateTime(String source) {
        try {
            new DateTime(source);
        }
        catch (DateTimeException e) {
            return false;
        }
        return true;
    }

    public DateTime() {
        this(new Date(), new Time());
    }

    public DateTime(Date date) {
        this(date, new Time());
    }

    public DateTime(Time time) {
        this(new Date(), time);
    }

    public DateTime(Date date, Time time) {
        this.setDate(date);
        this.setTime(time);
        this.setToStringDelimiter(" ");
    }

    public DateTime(Timestamp timeStamp) {
        this(new Date(timeStamp), new Time(timeStamp));
    }

    public DateTime(String dateTime) throws DateTimeException {
        this.setDateTime(dateTime);
        this.setToStringDelimiter(" ");
    }

    public DateTime(long dateTime) {
        this(new Date(dateTime), new Time(dateTime));
    }

    public Calendar getCalendar() {
        Calendar c = Calendar.getInstance();
        TimeZone tz = TimeZone.getDefault();
        int tzOffset = tz.getRawOffset();
        int secondsOffset = tzOffset / 1000;
        int minutesOffset = secondsOffset / 60;
        int hoursOffset = minutesOffset / 60;
        int year = this.date.getYear();
        int month = this.date.getMonth();
        int day = this.date.getDay();
        int hour = this.time.getHour() + hoursOffset;
        int minute = this.time.getMinute();
        int second = this.time.getSecond();
        int millisecond = this.time.getMillisecond();
        c.clear();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, millisecond);
        return c;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.date = date;
    }

    public Time getTime() {
        return this.time;
    }

    public void setTime(Time time) {
        if (time == null) {
            time = new Time();
        }
        this.time = time;
    }

    public void setDateTime(Date date, Time time) {
        this.setDate(date);
        this.setTime(time);
    }

    public void setDateTime(String dateTime) throws DateTimeException {
        if (StringUtility.isEmpty((String)dateTime)) {
            this.setDateTime(new Date(), new Time());
            return;
        }
        String originalDateTime = dateTime;
        try {
            dateTime = ((String)dateTime).trim().toLowerCase();
            int timeZoneOffset = 100;
            boolean ampm = false;
            if (DateTime.endsWithTimeZone((String)dateTime)) {
                timeZoneOffset = DateTime.getTimeZoneOffset((String)dateTime);
                String[] stringArray = TimeMetaData.TIMEZONES;
                int n = TimeMetaData.TIMEZONES.length;
                int n2 = 0;
                while (n2 < n) {
                    String tzCode = stringArray[n2];
                    if (((String)dateTime).endsWith(tzCode)) {
                        dateTime = ((String)dateTime).substring(0, ((String)dateTime).length() - tzCode.length()).trim();
                    }
                    ++n2;
                }
            }
            if (DateTime.hasTimeZoneOffset((String)dateTime)) {
                timeZoneOffset = DateTime.getTimeZoneOffset((String)dateTime);
                int offsetSign = ((String)dateTime).lastIndexOf(43);
                if (offsetSign == -1) {
                    offsetSign = ((String)dateTime).lastIndexOf(45);
                }
                dateTime = ((String)dateTime).substring(0, offsetSign).trim();
            }
            if (DateTime.beginsWithDay((String)dateTime)) {
                int separator = ((String)dateTime).indexOf(44);
                if (separator == -1) {
                    separator = ((String)dateTime).indexOf(32);
                }
                dateTime = ((String)dateTime).substring(separator + 1).trim();
            }
            try {
                Date date = new Date((String)dateTime);
                this.setDateTime(date, new Time(0, 0, 0));
                return;
            }
            catch (DateException date) {
                DateTime date2 = DateTime.deriveDateByContents((String)dateTime);
                if (date2 != null) {
                    this.setDateTime(date2.getDate(), date2.getTime());
                    return;
                }
                int[] separators = StringIndexer.indexCharacter((String)dateTime, ' ');
                if (separators.length == 0) {
                    separators = StringIndexer.indexCharacter((String)dateTime, 't');
                }
                if (separators.length == 0) {
                    String year = "";
                    String month = "";
                    String day = "";
                    String hour = "00";
                    String minute = "00";
                    String second = "00";
                    year = StringUtility.getLeftSubstring((String)dateTime, 4);
                    dateTime = ((String)dateTime).substring(4);
                    month = StringUtility.getLeftSubstring((String)dateTime, 2);
                    dateTime = ((String)dateTime).substring(2);
                    day = StringUtility.getLeftSubstring((String)dateTime, 2);
                    if (((String)(dateTime = ((String)dateTime).substring(2))).length() >= 2) {
                        hour = StringUtility.getLeftSubstring((String)dateTime, 2);
                        dateTime = ((String)dateTime).substring(2);
                    }
                    if (((String)dateTime).length() >= 2) {
                        minute = StringUtility.getLeftSubstring((String)dateTime, 2);
                        dateTime = ((String)dateTime).substring(2);
                    }
                    if (((String)dateTime).length() >= 2) {
                        second = StringUtility.getLeftSubstring((String)dateTime, 2);
                        dateTime = ((String)dateTime).substring(2);
                    }
                    dateTime = year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
                    separators = StringIndexer.indexCharacter((String)dateTime, ' ');
                }
                int splitIndex = -1;
                splitIndex = separators[separators.length - 1];
                String timeString = ((String)dateTime).substring(splitIndex + 1).trim();
                if ((timeString.equals("am") || timeString.equals("pm") || timeString.equals("a") || timeString.equals("p")) && (timeString = ((String)dateTime).substring((splitIndex = separators[separators.length - 2]) + 1).trim()).charAt(0) == 'p') {
                    ampm = true;
                }
                String dateString = ((String)dateTime).substring(0, splitIndex);
                Date date3 = null;
                try {
                    date3 = new Date(dateString);
                }
                catch (Exception e) {
                    splitIndex = separators[0];
                    dateString = ((String)dateTime).substring(0, splitIndex);
                    timeString = ((String)dateTime).substring(splitIndex + 1);
                    date3 = new Date(dateString);
                }
                Time time = new Time(timeString);
                this.setDateTime(date3, time);
                if (ampm) {
                    this.time.setHour(this.time.getHour() + 12);
                }
                if (timeZoneOffset != 100) {
                    int changeInHours;
                    int hour = this.time.getHour();
                    int rawChange = hour + (changeInHours = this.time.setTimeZone(timeZoneOffset));
                    if (rawChange < 0) {
                        this.date.addDays(-1);
                    } else if (rawChange > 23) {
                        this.date.addDays(1);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DateTimeException("The date time \"" + originalDateTime + "\" is not a valid date time.");
        }
    }

    public SimpleDateFormat getFormatter() {
        return this.formatter;
    }

    public void setFormatter(SimpleDateFormat formatter) {
        this.formatter = formatter;
    }

    private static boolean endsWithTimeZone(String dateTime) {
        String[] stringArray = TimeMetaData.TIMEZONES;
        int n = TimeMetaData.TIMEZONES.length;
        int n2 = 0;
        while (n2 < n) {
            String timezone = stringArray[n2];
            if (dateTime.endsWith(timezone)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean hasTimeZoneOffset(String dateTime) {
        String offsetPeriod;
        int offsetSign = dateTime.lastIndexOf(43);
        if (offsetSign == -1) {
            offsetSign = dateTime.lastIndexOf(45);
        }
        if (offsetSign == -1) {
            return false;
        }
        String offsetValue = dateTime.substring(offsetSign);
        char firstChar = offsetValue.charAt(0);
        return (firstChar == '+' || firstChar == '-') && NumberUtility.isNumber(offsetPeriod = offsetValue.substring(1).replaceAll(":", ""));
    }

    private static int getTimeZoneOffset(String dateTime) {
        double timeZoneOffset = 0.0;
        int extractPoint = -1;
        if (DateTime.hasTimeZoneOffset(dateTime)) {
            int offsetSign = dateTime.lastIndexOf(43);
            if (offsetSign == -1) {
                offsetSign = dateTime.lastIndexOf(45);
            }
            String offsetValue = dateTime.substring(offsetSign).replaceAll(":", "");
            timeZoneOffset = (double)Integer.parseInt(offsetValue) / 100.0;
            if (TimeZone.getDefault().inDaylightTime(new java.util.Date()) && timeZoneOffset != 0.0) {
                timeZoneOffset -= 1.0;
            }
            return (int)(timeZoneOffset * 60.0);
        }
        String[] stringArray = TimeMetaData.TIMEZONES;
        int n = TimeMetaData.TIMEZONES.length;
        int n2 = 0;
        while (n2 < n) {
            String tzCode = stringArray[n2];
            if (dateTime.endsWith(tzCode)) {
                extractPoint = dateTime.lastIndexOf(tzCode);
                break;
            }
            ++n2;
        }
        if (extractPoint == -1) {
            extractPoint = dateTime.lastIndexOf(32) + 1;
        }
        if (extractPoint >= 0) {
            String timeZoneCode = dateTime.substring(extractPoint);
            timeZoneOffset = TimeMetaData.getTimeZoneOffset(timeZoneCode);
        }
        return (int)(timeZoneOffset * 60.0);
    }

    public void addDays(int numberOfDays) {
        this.date.addDays(numberOfDays);
    }

    public void addMonths(int numberOfMonths) {
        this.date.addMonths(numberOfMonths);
    }

    public void addYears(int numberOfYears) {
        this.date.addYears(numberOfYears);
    }

    public void addSeconds(int seconds) {
        int adjustment = this.time.getSecond() + seconds;
        if (Math.abs(adjustment) > 59 || adjustment < 0) {
            int minutes = adjustment / 60 + (adjustment < 0 ? -1 : 0);
            seconds = adjustment % 60;
            if (seconds < 0) {
                seconds += 60;
            }
            this.time.setSecond(seconds);
            this.addMinutes(minutes);
        } else {
            this.time.addSeconds(seconds);
        }
    }

    public void addMinutes(int minutes) {
        int adjustment = this.time.getMinute() + minutes;
        if (Math.abs(adjustment) > 59 || adjustment < 0) {
            int hours = adjustment / 60 + (adjustment < 0 ? -1 : 0);
            minutes = adjustment % 60;
            if (minutes < 0) {
                minutes += 60;
            }
            this.time.setMinute(minutes);
            this.addHours(hours);
        } else {
            this.time.addMinutes(minutes);
        }
    }

    public void addHours(int hours) {
        int adjustment = this.time.getHour() + hours;
        if (Math.abs(adjustment) > 24 || adjustment < 0) {
            int days = adjustment / 24 + (adjustment < 0 ? -1 : 0);
            hours = adjustment % 24;
            if (hours < 0) {
                hours += 24;
            }
            this.time.setHour(hours);
            this.addDays(days);
        } else {
            this.time.addHours(hours);
        }
    }

    public boolean isBefore(DateTime that) {
        long thatTime;
        if (that == null) {
            return false;
        }
        long thisTime = this.getNumericalValue();
        return thisTime < (thatTime = that.getNumericalValue());
    }

    public boolean isAfter(DateTime that) {
        long thatTime;
        if (that == null) {
            return true;
        }
        long thisTime = this.getNumericalValue();
        return thisTime > (thatTime = that.getNumericalValue());
    }

    private long getNumericalValue() {
        Date date = this.getDate();
        Time time = this.getTime();
        int year = date.getYear();
        int month = date.getMonth();
        int day = date.getDay();
        int hour = time.getHour();
        int minute = time.getMinute();
        int seconds = time.getSecond();
        int millis = time.getMillisecond();
        long n = (long)year * 10000000000000L;
        n += (long)month * 100000000000L;
        n += (long)day * 1000000000L;
        n += (long)hour * 10000000L;
        n += (long)minute * 100000L;
        n += (long)seconds * 1000L;
        return n += (long)millis;
    }

    private static boolean beginsWithDay(String dateTime) {
        String[] stringArray = DateMetaData.DAY_NAMES;
        int n = DateMetaData.DAY_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String dayName = stringArray[n2];
            String lcDN = dayName.toLowerCase();
            String abbrv = StringUtility.getLeftSubstring(lcDN, 3);
            if (dateTime.startsWith(lcDN) || dateTime.startsWith(abbrv)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static DateTime deriveDateByContents(String dateTime) {
        int month = DateTime.getMonthFromContents(dateTime);
        if (month == -1) {
            return null;
        }
        int year = DateTime.getYearFromContents(dateTime);
        if (year == -1) {
            return null;
        }
        Time time = DateTime.getTimeFromContents(dateTime);
        if (time == null) {
            return null;
        }
        int day = DateTime.getDayFromContents(dateTime);
        if (day == -1) {
            return null;
        }
        Date date = new Date(++month, day, year);
        return new DateTime(date, time);
    }

    private static int getMonthFromContents(String dateTime) {
        int mn = 0;
        while (mn < DateMetaData.MONTH_NAMES.length) {
            String lcMN = DateMetaData.MONTH_NAMES[mn].toLowerCase();
            if (dateTime.contains(lcMN)) {
                return mn;
            }
            String abbrv = lcMN.substring(0, 3);
            if (dateTime.contains(abbrv)) {
                return mn;
            }
            ++mn;
        }
        return -1;
    }

    private static int getYearFromContents(String dateTime) {
        String[] parts;
        String[] stringArray = parts = DateTime.splitToDigits(dateTime);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if ((part = part.trim()).length() == 4 && NumberUtility.isNumber(part)) {
                return Integer.parseInt(part);
            }
            ++n2;
        }
        return -1;
    }

    private static String[] splitToDigits(String dateTime) {
        dateTime = StringUtility.replaceAllExcept(dateTime, "0123456789", " ", true);
        String[] digits = dateTime.split("\\s");
        return digits;
    }

    private static Time getTimeFromContents(String dateTime) {
        int beginning;
        int colon = dateTime.indexOf(":");
        if (colon == -1) {
            return null;
        }
        int colonCount = StringIndexer.countCharacter(dateTime, ':');
        if (colonCount > 2) {
            dateTime = dateTime.replaceFirst(":", " ");
            colon = dateTime.indexOf(":");
        }
        if ((beginning = dateTime.lastIndexOf(32, colon) + 1) == -1) {
            return null;
        }
        int ending = dateTime.indexOf(32, colon);
        if (ending == -1) {
            if (dateTime.length() - beginning == 8) {
                dateTime = dateTime.substring(beginning);
            }
        } else {
            dateTime = dateTime.substring(beginning, ending);
        }
        try {
            Time time = new Time(dateTime);
            return time;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static int getDayFromContents(String dateTime) {
        String[] parts;
        String[] stringArray = parts = DateTime.splitToDigits(dateTime);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            int day;
            String part = stringArray[n2];
            part = part.trim();
            if (NumberUtility.isInteger(part = part.replace(",", "")) && (day = Integer.parseInt(part)) > 0 && day < 32) {
                return day;
            }
            ++n2;
        }
        return -1;
    }

    public Timestamp toJavaSQLTimestamp() {
        SimpleDateFormat dateFormat = this.date.getFormat();
        SimpleDateFormat timeFormat = this.time.getFormat();
        this.date.setFormat(Date.SQL_FORMAT);
        this.time.setFormat(Time.FULL_FORMAT);
        String str = this.toString();
        Timestamp ts = Timestamp.valueOf(str);
        this.date.setFormat(dateFormat);
        this.time.setFormat(timeFormat);
        return ts;
    }

    @Override
    public int compareTo(DateTime that) {
        long thatDate;
        if (that == null) {
            return 1;
        }
        if (this.equals(that)) {
            return 0;
        }
        long thisDate = this.getNumericalValue();
        long diff = thisDate - (thatDate = that.getNumericalValue());
        return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof DateTime) {
            DateTime that = (DateTime)o;
            return this.getNumericalValue() == that.getNumericalValue();
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.formatter == null) {
            String dateString = this.getDate().toString();
            String timeString = this.getTime().toString();
            return String.format("%s%s%s", dateString, this.getToStringDelimiter(), timeString);
        }
        return this.formatter.format(this.getCalendar().getTime());
    }

    public static void main(String[] args) {
        String[] tests;
        String someTime = "Fri, 07 Sep 2012 00:00:00 EDT";
        DateTime dt1 = new DateTime(someTime);
        DateTime dt2 = new DateTime(someTime);
        System.out.printf("%s equals %s: %b\r\n", dt1.toString(), dt2.toString(), dt1.equals(dt2));
        String[] stringArray = tests = new String[]{"06/24/2012 20: 9:56.879", "21/Apr/2021:00:00:44 -0500", "20220204T162214.076Z", "Fri Nov  1 18:49:40 2009", "Tue, Jul 04, 2009 13:12:22", "Sat Oct 12 19:13:32 2009", "20071013T215756.595Z", "2006-07-05T05:00:00.000Z", "20031114T154433Z", "20031027105250331EDT", "Wed Jul 03 2003 14:00:50", "Sun, 09 Sep 2002 22:43:27 +0400", "Fri, 07 Sep 2002 00:00:00 EDT", "08 Aug 2002 14:01:04 -0400", "Wed, 4, Jul 2002 19:54", "Sun, 9 Sep 2002 03:53:03 UT", "Fri, 27 Jul 2002 23:38:47 EDT", "14 apr 2002 23:58:27 mdt", "Wed, 6 Jun 2002 24:39:49 EST", "14 apr 2002 23:58:27 pst", "14 apr 2002 23:58:27 pdt", "14 apr 2002 23:58:27 cst", "Wed, 4, Jul 2002 19:54", "Sat, 02 Jun 2002 00:00:00 00", "Mon, 14 May 2002 19:20:59 +0000", "2002-05-09T20:49:06-04:00", "2002-04-15T00:33:40Z", "2002-07-28T00:45:00Z", "14 apr 2002 13:24:08", "Thu, 26 Jul 2002 23:47:17 -0600", "Jan 21, 1997 10:15:21 am", "10/21/2006 23:14:15.22", "31MAR2008 11:12:13", "15 APR 1998 10p", "Wed, 28 Oct 2009 13:50:38 GMT", "Thu, 29 Oct 2009 14:55:00", "30 Oct 2009 14:55:00 GMT", "31 Oct 2009 14:55:00", "january 1, 1970", "Thursday, Aug 10, 2010 2a", "Saturday, September 15, 1947"};
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String test = stringArray[n2];
            System.out.print("DateTime.main(args): " + test + " ==> ");
            System.out.println(new DateTime(test));
            ++n2;
        }
        DateTime dateTime = new DateTime();
        System.out.println("Original Date Time: " + String.valueOf(dateTime));
        dateTime.addSeconds(120);
        dateTime.addMinutes(120);
        dateTime.addHours(48);
        System.out.println("Date Time After time change: " + String.valueOf(dateTime));
    }
}

