/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class PreHashedMap<V>
extends AbstractMap<String, V> {
    private final int rows;
    private final int size;
    private final int shift;
    private final int mask;
    private final Object[] ht;

    protected PreHashedMap(int rows, int size, int shift, int mask) {
        this.rows = rows;
        this.size = size;
        this.shift = shift;
        this.mask = mask;
        this.ht = new Object[rows];
        this.init(this.ht);
    }

    protected abstract void init(Object[] var1);

    private V toV(Object x) {
        return (V)x;
    }

    @Override
    public V get(Object k) {
        int h = k.hashCode() >> this.shift & this.mask;
        Object[] a = (Object[])this.ht[h];
        if (a == null) {
            return null;
        }
        while (!a[0].equals(k)) {
            if (a.length < 3) {
                return null;
            }
            a = (Object[])a[2];
        }
        return this.toV(a[1]);
    }

    @Override
    public V put(String k, V v) {
        int h = k.hashCode() >> this.shift & this.mask;
        Object[] a = (Object[])this.ht[h];
        if (a == null) {
            throw new UnsupportedOperationException(k);
        }
        while (true) {
            if (a[0].equals(k)) {
                V ov = this.toV(a[1]);
                a[1] = v;
                return ov;
            }
            if (a.length < 3) {
                throw new UnsupportedOperationException(k);
            }
            a = (Object[])a[2];
        }
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public int size() {
                return PreHashedMap.this.size;
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int i = -1;
                    Object[] a = null;
                    String cur = null;

                    private boolean findNext() {
                        if (this.a != null) {
                            if (this.a.length == 3) {
                                this.a = (Object[])this.a[2];
                                this.cur = (String)this.a[0];
                                return true;
                            }
                            ++this.i;
                            this.a = null;
                        }
                        this.cur = null;
                        if (this.i >= (this).PreHashedMap.this.rows) {
                            return false;
                        }
                        if (this.i < 0 || (this).PreHashedMap.this.ht[this.i] == null) {
                            do {
                                if (++this.i < (this).PreHashedMap.this.rows) continue;
                                return false;
                            } while ((this).PreHashedMap.this.ht[this.i] == null);
                        }
                        this.a = (Object[])(this).PreHashedMap.this.ht[this.i];
                        this.cur = (String)this.a[0];
                        return true;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.cur != null) {
                            return true;
                        }
                        return this.findNext();
                    }

                    @Override
                    public String next() {
                        if (this.cur == null && !this.findNext()) {
                            throw new NoSuchElementException();
                        }
                        String s = this.cur;
                        this.cur = null;
                        return s;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            public int size() {
                return PreHashedMap.this.size;
            }

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                return new Iterator<Map.Entry<String, V>>(){
                    final Iterator<String> i;
                    {
                        this.i = PreHashedMap.this.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<String, V> next() {
                        return new Map.Entry<String, V>(){
                            String k;
                            {
                                this.k = i.next();
                            }

                            @Override
                            public String getKey() {
                                return this.k;
                            }

                            @Override
                            public V getValue() {
                                return PreHashedMap.this.get(this.k);
                            }

                            @Override
                            public int hashCode() {
                                Object v = PreHashedMap.this.get(this.k);
                                return this.k.hashCode() + (v == null ? 0 : v.hashCode());
                            }

                            @Override
                            public boolean equals(Object ob) {
                                if (ob == this) {
                                    return true;
                                }
                                if (!(ob instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry that = (Map.Entry)ob;
                                return (this.getKey() == null ? that.getKey() == null : this.getKey().equals(that.getKey())) && (this.getValue() == null ? that.getValue() == null : this.getValue().equals(that.getValue()));
                            }

                            @Override
                            public V setValue(V v) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

