/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.util.Pair;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringIndexer {
    private StringIndexer() {
    }

    public static int countCharacter(String s, char c) {
        return StringIndexer.countCharacter(s.toCharArray(), c);
    }

    public static int countCharacter(StringBuilder s, char c) {
        return StringIndexer.countCharacter(s.toString(), c);
    }

    public static int countCharacter(char[] arr, char c) {
        int count = 0;
        int i = arr.length - 1;
        while (i >= 0) {
            if (arr[i] == c) {
                ++count;
            }
            --i;
        }
        return count;
    }

    public static int countStrings(String source, String target) {
        int count = 0;
        int pos = source.indexOf(target);
        while (pos >= 0) {
            ++count;
            pos = source.indexOf(target, pos + target.length());
        }
        return count;
    }

    public static int countStrings(char[] source, String target) {
        return StringIndexer.countStrings(new String(source), target);
    }

    public static int countStrings(String source, String target, boolean caseSensitive) {
        if (caseSensitive) {
            return StringIndexer.countStrings(source, target);
        }
        return StringIndexer.countStrings(source.toLowerCase(), target.toLowerCase());
    }

    public static int countPattern(String source, String regex) {
        return StringIndexer.countPattern(source, Pattern.compile(regex));
    }

    public static int countPattern(String source, Pattern pattern) {
        int count = 0;
        Matcher matcher = pattern.matcher(source);
        boolean match = matcher.find();
        while (match) {
            ++count;
            match = matcher.find(matcher.end());
        }
        return count;
    }

    public static int[] indexCharacter(String s, char c) {
        return StringIndexer.indexCharacter(s.toCharArray(), c);
    }

    public static int[] indexCharacter(char[] arr, char c) {
        int count = StringIndexer.countCharacter(arr, c);
        int[] index = new int[count];
        if (count > 0) {
            int i = 0;
            int j = 0;
            while (i < arr.length) {
                if (arr[i] == c) {
                    index[j++] = i;
                }
                ++i;
            }
        }
        return index;
    }

    public static int[] indexUnquotedCharacter(String s, char c) {
        return StringIndexer.indexUnquotedCharacter(s.toCharArray(), c);
    }

    public static int[] indexUnquotedCharacter(char[] arr, char c) {
        int quoteChar = 32;
        int count = StringIndexer.countCharacter(arr, c);
        int[] index = new int[count];
        if (count > 0) {
            int i = 0;
            int j = 0;
            while (i < arr.length) {
                if (quoteChar != 32 && arr[i] == quoteChar) {
                    quoteChar = 32;
                } else if (quoteChar == 32) {
                    if (arr[i] == '\'' || arr[i] == '\"') {
                        quoteChar = arr[i];
                    } else if (arr[i] == c) {
                        index[j++] = i;
                    }
                }
                ++i;
            }
        }
        return index;
    }

    public static int[] indexString(String source, String target, boolean caseSensitive) {
        String searchSource = source;
        String searchTarget = target;
        if (!caseSensitive) {
            searchSource = source.toLowerCase();
            searchTarget = target.toLowerCase();
        }
        int count = StringIndexer.countStrings(searchSource, searchTarget);
        int[] index = new int[count];
        int pos = source.indexOf(searchTarget);
        int i = 0;
        while (pos > 0) {
            index[i++] = pos;
            pos = source.indexOf(searchTarget, pos + target.length());
        }
        return index;
    }

    public static Pair<Integer, Integer>[] indexPattern(String source, String regex) {
        return StringIndexer.indexPattern(source, Pattern.compile(regex));
    }

    public static Pair<Integer, Integer>[] indexPattern(String source, Pattern pattern) {
        int count = StringIndexer.countPattern(source, pattern);
        Pair[] index = new Pair[count];
        Matcher matcher = pattern.matcher(source);
        boolean match = matcher.find();
        int i = 0;
        while (match) {
            Pair<Integer, Integer> ix = new Pair<Integer, Integer>(matcher.start(), matcher.end());
            index[i++] = ix;
            match = matcher.find(matcher.end());
        }
        return index;
    }

    public static int findClosingCharacter(String s, int start) throws NullPointerException, ArrayIndexOutOfBoundsException {
        return StringIndexer.findClosingCharacter(s.toCharArray(), start);
    }

    public static int findClosingCharacter(char[] arr, int start) throws NullPointerException, ArrayIndexOutOfBoundsException {
        char endCharacter;
        boolean isSpecial = false;
        int nestLevel = 0;
        if (arr == null) {
            throw new NullPointerException("StringIndexer.findClosingCharacter():  The search parameter cannot be null.");
        }
        if (start < 0 || start > arr.length - 2) {
            throw new ArrayIndexOutOfBoundsException("StringIndexer.findClosingCharacter():  The starting position " + start + " is invalid or out of range.");
        }
        char beginCharacter = arr[start];
        switch (beginCharacter) {
            case '(': {
                endCharacter = ')';
                isSpecial = true;
                break;
            }
            case '{': {
                endCharacter = '}';
                isSpecial = true;
                break;
            }
            case '[': {
                endCharacter = ']';
                isSpecial = true;
                break;
            }
            case '<': {
                endCharacter = '>';
                isSpecial = true;
                break;
            }
            default: {
                endCharacter = beginCharacter;
            }
        }
        int i = start + 1;
        while (i < arr.length) {
            if (arr[i] == endCharacter && nestLevel == 0) {
                return i;
            }
            if (isSpecial && arr[i] == beginCharacter) {
                ++nestLevel;
            } else if (isSpecial && arr[i] == endCharacter) {
                --nestLevel;
            }
            ++i;
        }
        return -1;
    }

    public static void main(String[] args) {
        String[] test = new String[]{"--c-ccc----ccc--cccccccccc--c--ccc-cc", "c--c-ccc----ccc--cccccccccc--c--ccc-cc", "--c-ccc----ccc--cccccccccc--c--ccc-c-"};
        int i = 0;
        while (i < test.length) {
            System.out.println("Test " + i + ": " + test[i] + ": " + StringIndexer.countCharacter(test[i], 'c'));
            ++i;
        }
        int[] nArray = new int[3];
        nArray[1] = 4;
        nArray[2] = 9;
        int[] testChar = nArray;
        test[0] = "abcdefg ABCDEFG abcdefg";
        test[1] = "i = (((4 + 3) - 2 + (6 * 8) - 3) / 12) * 5";
        test[2] = "He said, 'Mary's eyes are pretty'";
        int i2 = 0;
        while (i2 < test.length) {
            System.out.println("Test " + i2 + ": " + test[i2] + ": " + StringIndexer.findClosingCharacter(test[i2], testChar[i2]));
            ++i2;
        }
        char[] indexChar = new char[]{'b', '(', 'e'};
        int i3 = 0;
        while (i3 < test.length) {
            int[] index = StringIndexer.indexCharacter(test[i3], indexChar[i3]);
            System.out.print("Test " + i3 + ": " + test[i3] + ": (");
            int j = 0;
            while (j < index.length) {
                System.out.print(index[j] + (j < index.length - 1 ? ", " : ""));
                ++j;
            }
            System.out.println(")");
            ++i3;
        }
        String source = "The quick brown fox jumped over the lazy moon";
        System.out.println("'The' case insensitive in " + source + " = " + StringIndexer.countStrings(source, "The", false));
        System.out.println("Locations of 'The' case insensitive in " + source + " = " + Arrays.toString(StringIndexer.indexString(source, "The", false)));
        System.out.println("'The' case sensitive in " + source + " = " + StringIndexer.countStrings(source, "The", true));
        System.out.println("Locations of 'The' case sensitive in " + source + " = " + Arrays.toString(StringIndexer.indexString(source, "The", true)));
        source = "<p>\r\nthis is para 1</p>asdfasdf\r\nasdfasdfafdvsd<p>this is para 2</p>asdfasdf\r\nvsdfvsd<P>\r\nthis is para 3</p>vasdfvsdfv\r\newrwertewrtwer<p>this is para 4</P>svsdfv\r\nsvsdfvdf<P>this is para 5</P>svdfvsdf";
        System.out.println("Source is:\n" + source + "\n");
        System.out.println("<[Pp]>.*?</[Pp]> in source  = " + StringIndexer.countPattern(source, "(?ms)<[Pp]>.*?</[Pp]>"));
        System.out.println("Locations of '<[Pp]>.*?</[Pp]>' in source = " + Arrays.toString(StringIndexer.indexPattern(source, "(?ms)<[Pp]>.*?</[Pp]>")));
    }
}

