/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.TimerEvent;
import com.jmorgan.util.TimerListener;
import java.util.ArrayList;

public class Timer {
    private TimerEvent timerEvent;
    private ArrayList<TimerListener> timerListeners = new ArrayList();
    private long delay;
    private long count = 1L;
    private AsynchMethodInvoker<Void> notificationThread;

    private Timer() {
        this.timerEvent = new TimerEvent(null, this, "timer event");
    }

    public Timer(TimerListener listener, long delay) {
        this(listener, delay, 1L, "timer event");
    }

    public Timer(TimerListener listener, long delay, String message) {
        this(listener, delay, 1L, message);
    }

    public Timer(TimerListener listener, long delay, long count) {
        this(listener, delay, count, "timer event");
    }

    public Timer(long delay) {
        this(delay, 1L, "timer event");
    }

    public Timer(long delay, String message) {
        this(delay, 1L, message);
    }

    public Timer(long delay, long count) {
        this(delay, count, "timer event");
    }

    public Timer(long delay, long count, String message) {
        this();
        this.delay = delay;
        this.count = count;
        this.timerEvent.setMessage(message);
    }

    public Timer(TimerListener listener, long delay, long count, String message) {
        this();
        this.addTimerListener(listener);
        this.delay = delay;
        this.count = count;
        this.timerEvent.setMessage(message);
        this.start();
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void start() {
        if (this.notificationThread != null) {
            this.notificationThread.cancel();
            this.notificationThread = null;
        }
        this.notificationThread = new AsynchMethodInvoker((Object)this, "processTime");
    }

    public void addTimerListener(TimerListener listener) {
        this.timerListeners.add(listener);
    }

    public void removeTimerListener(TimerListener listener) {
        this.timerListeners.remove(listener);
    }

    @Reflected
    private void processTime() {
        if (this.delay > 0L) {
            ThreadUtility.sleep(this.delay);
        }
        this.fireTimerEvent();
        if (this.count > 0L) {
            this.start();
        }
    }

    private void fireTimerEvent() {
        this.timerEvent.setTime(new Time());
        for (TimerListener listener : this.timerListeners) {
            new AsynchMethodInvoker((Object)listener, "timerEventTriggered", (Object)this.timerEvent);
        }
        --this.count;
    }
}

