/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CollectionUtility;
import java.util.Collection;
import java.util.Iterator;

public abstract class CollectionService<E> {
    protected Collection<? extends E> collection;
    protected Iterator<? extends E> iterator;

    protected CollectionService(Collection<? extends E> collection) throws NullPointerException {
        this.setCollection(collection);
    }

    public Collection<? extends E> getCollection() {
        return this.collection;
    }

    public void setCollection(Collection<? extends E> collection) throws NullPointerException {
        if (collection == null) {
            throw new NullPointerException("The given collection cannot be null.");
        }
        this.collection = collection;
    }

    protected void iterateCollection() {
        if (CollectionUtility.isEmpty(this.collection)) {
            return;
        }
        for (E o : this.collection) {
            this.processElement(o);
        }
    }

    protected abstract void processElement(E var1);
}

