/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CollectionSelector;
import java.util.Collection;
import java.util.Comparator;

public class DifferenceSelector<E>
extends CollectionSelector<E> {
    public static final int SELECT_IF_LESS_THAN = -1;
    public static final int SELECT_IF_GREATER_THAN = 1;
    public static final int SELECT_IF_EQUAL_TO = 0;
    private Comparable<E> comparable;
    private E tester;
    private Comparator<E> comparator;
    private int compareType;

    public DifferenceSelector(Collection<? extends E> collection, Comparable<E> tester, int compareType) throws NullPointerException, IllegalArgumentException {
        super(collection);
        this.setComparable(tester);
        this.setCompareType(compareType);
    }

    public DifferenceSelector(Collection<? extends E> collection, Comparator<E> comparator, E tester, int compareType) throws NullPointerException, IllegalArgumentException {
        super(collection);
        this.setComparison(comparator, tester);
        this.setCompareType(compareType);
    }

    @Override
    protected boolean isElementSelected(E element) {
        if (this.comparable != null) {
            switch (this.compareType) {
                case 0: {
                    if (this.comparable.compareTo(element) != 0) break;
                    return true;
                }
                case 1: {
                    if (this.comparable.compareTo(element) >= 0) break;
                    return true;
                }
                case -1: {
                    if (this.comparable.compareTo(element) <= 0) break;
                    return true;
                }
            }
        }
        if (this.comparator != null) {
            switch (this.compareType) {
                case 0: {
                    if (this.comparator.compare(this.tester, element) != 0) break;
                    return true;
                }
                case 1: {
                    if (this.comparator.compare(this.tester, element) >= 0) break;
                    return true;
                }
                case -1: {
                    if (this.comparator.compare(this.tester, element) <= 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public Comparable<E> getComparable() {
        return this.comparable;
    }

    public Comparator<E> getComparator() {
        return this.comparator;
    }

    public int getComparisonType() {
        return this.compareType;
    }

    public void setComparable(Comparable<E> tester) throws NullPointerException {
        if (tester == null) {
            throw new NullPointerException("The given Comparable cannot be null.");
        }
        this.comparable = tester;
        this.comparator = null;
    }

    public void setComparison(Comparator<E> comparator, E tester) throws NullPointerException {
        if (comparator == null) {
            throw new NullPointerException("The given comparator cannot be null.");
        }
        if (tester == null) {
            throw new NullPointerException("The given tester cannot be null.");
        }
        this.comparator = comparator;
        this.tester = tester;
        this.comparable = null;
    }

    public void setCompareType(int compareType) throws IllegalArgumentException {
        switch (compareType) {
            case -1: 
            case 0: 
            case 1: {
                this.compareType = compareType;
                break;
            }
            default: {
                throw new IllegalArgumentException("The compareType is invalid.");
            }
        }
    }
}

