/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import com.jmorgan.util.logging.StandardConsoleHandler;
import com.jmorgan.util.logging.StandardLogFormatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class LoggingConfig {
    private static Logger rootLogger;
    private static StandardLogFormatter formatter;
    private static StandardConsoleHandler consoleHandler;

    private LoggingConfig() {
    }

    public static void initialize() {
        LogManager.getLogManager().reset();
        rootLogger = Logger.getLogger("");
        rootLogger.setLevel(Level.ALL);
        formatter = new StandardLogFormatter();
        consoleHandler = new StandardConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(formatter);
        rootLogger.addHandler(consoleHandler);
    }

    public static Logger getRootLogger() {
        return rootLogger;
    }

    public static StandardLogFormatter getFormatter() {
        return formatter;
    }

    public static StandardConsoleHandler getConsoleHandler() {
        return consoleHandler;
    }

    public static void setLogLevel(Level level) {
        rootLogger.setLevel(level);
        consoleHandler.setLevel(level);
    }
}

