/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;

public class MessageFilter
implements Filter {
    private Pattern regexPattern;

    public MessageFilter(String regex) {
        this.regexPattern = Pattern.compile(regex, 32);
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        String message = record.getMessage();
        String sourceClassName = record.getSourceClassName();
        String sourceMethodName = record.getSourceMethodName();
        String combined = String.format("%s.%s %s", sourceClassName, sourceMethodName, message);
        return this.regexPattern.matcher(combined).matches();
    }
}

