/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPICollection;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionUpdateAPIApplication
extends DataPowerAction {
    private ObjectReference<ConfigAPICollection> aPICollection;
    private String appID;
    private String appName;
    private String enabled;
    private String lifecycleState;
    private String applicationType;
    private String orgID;
    private String orgName;
    private String orgTitle;
    private String redirectURLs;
    private String certificates;
    private String metadata;

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="APICollection", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference<ConfigAPICollection>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API collection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPICollection> getAPICollection() {
        return this.aPICollection;
    }

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="APICollection", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference<ConfigAPICollection>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API collection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICollection(ObjectReference<ConfigAPICollection> aPICollection) {
        this.aPICollection = aPICollection;
    }

    @XMLInfo(elementType="element", elementName="AppID", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="appID", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9a-z-]{1,36}$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAppID() {
        return this.appID;
    }

    @XMLInfo(elementType="element", elementName="AppID", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="appID", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9a-z-]{1,36}$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAppID(String appID) {
        if (appID != null && appID.matches("^[0-9a-z-]{1,36}$")) {
            this.appID = appID;
        }
    }

    @XMLInfo(elementType="element", elementName="AppName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="appName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAppName() {
        return this.appName;
    }

    @XMLInfo(elementType="element", elementName="AppName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="appName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAppName(String appName) {
        this.appName = appName;
    }

    @XMLInfo(elementType="element", elementName="Enabled", elementOrder=3, dataPowerType="dmAppEnabled", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enabled", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application enabled", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnabled() {
        return this.enabled;
    }

    @XMLInfo(elementType="element", elementName="Enabled", elementOrder=3, dataPowerType="dmAppEnabled", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="enabled", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application enabled", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnabled(String enabled) {
        if (Comparison.isIn(enabled, DPEnumerations.APP_ENABLED)) {
            this.enabled = enabled;
        }
    }

    @XMLInfo(elementType="element", elementName="LifecycleState", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="lifecycleState", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=11, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application lifecycle state", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLifecycleState() {
        return this.lifecycleState;
    }

    @XMLInfo(elementType="element", elementName="LifecycleState", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="lifecycleState", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=11, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application lifecycle state", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLifecycleState(String lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @XMLInfo(elementType="element", elementName="ApplicationType", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="applicationType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=146, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getApplicationType() {
        return this.applicationType;
    }

    @XMLInfo(elementType="element", elementName="ApplicationType", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="applicationType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=146, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    @XMLInfo(elementType="element", elementName="OrgID", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="orgID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Developer organization ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOrgID() {
        return this.orgID;
    }

    @XMLInfo(elementType="element", elementName="OrgID", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="orgID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Developer organization ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    @XMLInfo(elementType="element", elementName="OrgName", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="orgName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Developer organization name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOrgName() {
        return this.orgName;
    }

    @XMLInfo(elementType="element", elementName="OrgName", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="orgName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Developer organization name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @XMLInfo(elementType="element", elementName="OrgTitle", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="orgTitle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Developer organization title", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOrgTitle() {
        return this.orgTitle;
    }

    @XMLInfo(elementType="element", elementName="OrgTitle", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="orgTitle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=48, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Developer organization title", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOrgTitle(String orgTitle) {
        this.orgTitle = orgTitle;
    }

    @XMLInfo(elementType="element", elementName="RedirectURLs", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="redirectURLs", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="(^\\.\\*$|^http(s?):\\/\\/[^,]+(,http(s?):\\/\\/[^,]+)*$)", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Redirect URLs", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRedirectURLs() {
        return this.redirectURLs;
    }

    @XMLInfo(elementType="element", elementName="RedirectURLs", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="redirectURLs", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="(^\\.\\*$|^http(s?):\\/\\/[^,]+(,http(s?):\\/\\/[^,]+)*$)", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Redirect URLs", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRedirectURLs(String redirectURLs) {
        if (redirectURLs != null && redirectURLs.matches("(^\\.\\*$|^http(s?):\\/\\/[^,]+(,http(s?):\\/\\/[^,]+)*$)")) {
            this.redirectURLs = redirectURLs;
        }
    }

    @XMLInfo(elementType="element", elementName="Certificates", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="certificates", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?|,$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application Certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCertificates() {
        return this.certificates;
    }

    @XMLInfo(elementType="element", elementName="Certificates", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="certificates", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?|,$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application Certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCertificates(String certificates) {
        if (certificates != null && certificates.matches("^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?|,$")) {
            this.certificates = certificates;
        }
    }

    @XMLInfo(elementType="element", elementName="Metadata", elementOrder=11, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="metadata", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=146, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application metadata", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMetadata() {
        return this.metadata;
    }

    @XMLInfo(elementType="element", elementName="Metadata", elementOrder=11, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="metadata", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=146, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application metadata", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public int compareTo(ActionUpdateAPIApplication that) {
        return this.compareTo(that, "aPICollection", "appID", "appName", "enabled", "lifecycleState", "applicationType", "orgID", "orgName", "orgTitle", "redirectURLs", "certificates", "metadata");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aPICollection, this.appID, this.appName, this.enabled, this.lifecycleState, this.applicationType, this.orgID, this.orgName, this.orgTitle, this.redirectURLs, this.certificates, this.metadata);
    }

    public boolean equals(Object that) {
        return this.equals(that, "aPICollection", "appID", "appName", "enabled", "lifecycleState", "applicationType", "orgID", "orgName", "orgTitle", "redirectURLs", "certificates", "metadata");
    }

    @Override
    public String toString() {
        return this.toString("aPICollection", "appID", "appName", "enabled", "lifecycleState", "applicationType", "orgID", "orgName", "orgTitle", "redirectURLs", "certificates", "metadata");
    }
}

